/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.spdy;

import com.koushikdutta.async.BufferedDataSink;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataEmitterReader;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.spdy.ByteString;
import com.koushikdutta.async.http.spdy.ErrorCode;
import com.koushikdutta.async.http.spdy.FrameReader;
import com.koushikdutta.async.http.spdy.FrameWriter;
import com.koushikdutta.async.http.spdy.Header;
import com.koushikdutta.async.http.spdy.HeadersMode;
import com.koushikdutta.async.http.spdy.HpackDraft08;
import com.koushikdutta.async.http.spdy.Settings;
import com.koushikdutta.async.http.spdy.Variant;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Http20Draft13
implements Variant {
    private static final Logger logger = Logger.getLogger(Http20Draft13.class.getName());
    private static final ByteString CONNECTION_PREFACE = ByteString.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
    static final int MAX_FRAME_SIZE = 16383;
    static final byte TYPE_DATA = 0;
    static final byte TYPE_HEADERS = 1;
    static final byte TYPE_PRIORITY = 2;
    static final byte TYPE_RST_STREAM = 3;
    static final byte TYPE_SETTINGS = 4;
    static final byte TYPE_PUSH_PROMISE = 5;
    static final byte TYPE_PING = 6;
    static final byte TYPE_GOAWAY = 7;
    static final byte TYPE_WINDOW_UPDATE = 8;
    static final byte TYPE_CONTINUATION = 9;
    static final byte FLAG_NONE = 0;
    static final byte FLAG_ACK = 1;
    static final byte FLAG_END_STREAM = 1;
    static final byte FLAG_END_SEGMENT = 2;
    static final byte FLAG_END_HEADERS = 4;
    static final byte FLAG_END_PUSH_PROMISE = 4;
    static final byte FLAG_PADDED = 8;
    static final byte FLAG_PRIORITY = 32;
    static final byte FLAG_COMPRESSED = 32;

    Http20Draft13() {
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    @Override
    public FrameReader newReader(DataEmitter source, FrameReader.Handler handler, boolean client) {
        return new Reader(source, handler, 4096, client);
    }

    @Override
    public FrameWriter newWriter(BufferedDataSink sink, boolean client) {
        return new Writer(sink, client);
    }

    @Override
    public int maxFrameSize() {
        return 16383;
    }

    private static IllegalArgumentException illegalArgument(String message, Object ... args) {
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, message, args));
    }

    private static IOException ioException(String message, Object ... args) throws IOException {
        throw new IOException(String.format(Locale.ENGLISH, message, args));
    }

    private static short lengthWithoutPadding(short length, byte flags, short padding) throws IOException {
        if ((flags & 8) != 0) {
            length = (short)(length - 1);
        }
        if (padding > length) {
            throw Http20Draft13.ioException("PROTOCOL_ERROR padding %s > remaining length %s", padding, length);
        }
        return (short)(length - padding);
    }

    static final class FrameLogger {
        private static final String[] TYPES;
        private static final String[] FLAGS;
        private static final String[] BINARY;

        FrameLogger() {
        }

        static String formatHeader(boolean inbound, int streamId, int length, byte type, byte flags) {
            String formattedType = type < TYPES.length ? TYPES[type] : String.format(Locale.ENGLISH, "0x%02x", type);
            String formattedFlags = FrameLogger.formatFlags(type, flags);
            return String.format(Locale.ENGLISH, "%s 0x%08x %5d %-13s %s", inbound ? "<<" : ">>", streamId, length, formattedType, formattedFlags);
        }

        static String formatFlags(byte type, byte flags) {
            String result;
            if (flags == 0) {
                return "";
            }
            switch (type) {
                case 4: 
                case 6: {
                    return flags == 1 ? "ACK" : BINARY[flags];
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    return BINARY[flags];
                }
            }
            String string = result = flags < FLAGS.length ? FLAGS[flags] : BINARY[flags];
            if (type == 5 && (flags & 4) != 0) {
                return result.replace("HEADERS", "PUSH_PROMISE");
            }
            if (type == 0 && (flags & 0x20) != 0) {
                return result.replace("PRIORITY", "COMPRESSED");
            }
            return result;
        }

        static {
            int[] frameFlags;
            TYPES = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
            FLAGS = new String[64];
            BINARY = new String[256];
            for (int i = 0; i < BINARY.length; ++i) {
                FrameLogger.BINARY[i] = String.format(Locale.ENGLISH, "%8s", Integer.toBinaryString(i)).replace(' ', '0');
            }
            FrameLogger.FLAGS[0] = "";
            FrameLogger.FLAGS[1] = "END_STREAM";
            FrameLogger.FLAGS[2] = "END_SEGMENT";
            FrameLogger.FLAGS[3] = "END_STREAM|END_SEGMENT";
            int[] prefixFlags = new int[]{1, 2, 3};
            FrameLogger.FLAGS[8] = "PADDED";
            for (int prefixFlag : prefixFlags) {
                FrameLogger.FLAGS[prefixFlag | 8] = FLAGS[prefixFlag] + "|PADDED";
            }
            FrameLogger.FLAGS[4] = "END_HEADERS";
            FrameLogger.FLAGS[32] = "PRIORITY";
            FrameLogger.FLAGS[36] = "END_HEADERS|PRIORITY";
            for (int frameFlag : frameFlags = new int[]{4, 32, 36}) {
                for (int prefixFlag : prefixFlags) {
                    FrameLogger.FLAGS[prefixFlag | frameFlag] = FLAGS[prefixFlag] + '|' + FLAGS[frameFlag];
                    FrameLogger.FLAGS[prefixFlag | frameFlag | 8] = FLAGS[prefixFlag] + '|' + FLAGS[frameFlag] + "|PADDED";
                }
            }
            for (int i = 0; i < FLAGS.length; ++i) {
                if (FLAGS[i] != null) continue;
                FrameLogger.FLAGS[i] = BINARY[i];
            }
        }
    }

    static final class Writer
    implements FrameWriter {
        private final BufferedDataSink sink;
        private final boolean client;
        private final HpackDraft08.Writer hpackWriter;
        private boolean closed;
        private final ByteBufferList frameHeader = new ByteBufferList();

        Writer(BufferedDataSink sink, boolean client) {
            this.sink = sink;
            this.client = client;
            this.hpackWriter = new HpackDraft08.Writer();
        }

        @Override
        public synchronized void ackSettings() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            int length = 0;
            byte type = 4;
            byte flags = 1;
            int streamId = 0;
            this.frameHeader(streamId, length, type, flags);
        }

        @Override
        public synchronized void connectionPreface() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (!this.client) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format(Locale.ENGLISH, ">> CONNECTION %s", CONNECTION_PREFACE.hex()));
            }
            this.sink.write(new ByteBufferList(CONNECTION_PREFACE.toByteArray()));
        }

        @Override
        public synchronized void synStream(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock) throws IOException {
            if (inFinished) {
                throw new UnsupportedOperationException();
            }
            if (this.closed) {
                throw new IOException("closed");
            }
            this.headers(outFinished, streamId, headerBlock);
        }

        @Override
        public synchronized void synReply(boolean outFinished, int streamId, List<Header> headerBlock) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.headers(outFinished, streamId, headerBlock);
        }

        @Override
        public synchronized void headers(int streamId, List<Header> headerBlock) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.headers(false, streamId, headerBlock);
        }

        @Override
        public synchronized void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            ByteBufferList hpackBuffer = this.hpackWriter.writeHeaders(requestHeaders);
            long byteCount = hpackBuffer.remaining();
            int length = (int)Math.min(16379L, byteCount);
            byte type = 5;
            byte flags = byteCount == (long)length ? (byte)4 : 0;
            this.frameHeader(streamId, length + 4, type, flags);
            ByteBuffer sink = ByteBufferList.obtain(8192).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(promisedStreamId & Integer.MAX_VALUE);
            sink.flip();
            this.frameHeader.add(sink);
            hpackBuffer.get(this.frameHeader, length);
            this.sink.write(this.frameHeader);
            if (byteCount > (long)length) {
                this.writeContinuationFrames(hpackBuffer, streamId);
            }
        }

        void headers(boolean outFinished, int streamId, List<Header> headerBlock) throws IOException {
            byte flags;
            if (this.closed) {
                throw new IOException("closed");
            }
            ByteBufferList hpackBuffer = this.hpackWriter.writeHeaders(headerBlock);
            long byteCount = hpackBuffer.remaining();
            int length = (int)Math.min(16383L, byteCount);
            byte type = 1;
            byte by = flags = byteCount == (long)length ? (byte)4 : 0;
            if (outFinished) {
                flags = (byte)(flags | 1);
            }
            this.frameHeader(streamId, length, type, flags);
            hpackBuffer.get(this.frameHeader, length);
            this.sink.write(this.frameHeader);
            if (byteCount > (long)length) {
                this.writeContinuationFrames(hpackBuffer, streamId);
            }
        }

        private void writeContinuationFrames(ByteBufferList hpackBuffer, int streamId) throws IOException {
            while (hpackBuffer.hasRemaining()) {
                int length = Math.min(16383, hpackBuffer.remaining());
                int newRemaining = hpackBuffer.remaining() - length;
                this.frameHeader(streamId, length, (byte)9, newRemaining == 0 ? (byte)4 : 0);
                hpackBuffer.get(this.frameHeader, length);
                this.sink.write(this.frameHeader);
            }
        }

        @Override
        public synchronized void rstStream(int streamId, ErrorCode errorCode) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (errorCode.spdyRstCode == -1) {
                throw new IllegalArgumentException();
            }
            int length = 4;
            byte type = 3;
            byte flags = 0;
            this.frameHeader(streamId, length, type, flags);
            ByteBuffer sink = ByteBufferList.obtain(8192).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(errorCode.httpCode);
            sink.flip();
            this.sink.write(this.frameHeader.add(sink));
        }

        @Override
        public synchronized void data(boolean outFinished, int streamId, ByteBufferList source) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            byte flags = 0;
            if (outFinished) {
                flags = (byte)(flags | 1);
            }
            this.dataFrame(streamId, flags, source);
        }

        void dataFrame(int streamId, byte flags, ByteBufferList buffer) throws IOException {
            byte type = 0;
            this.frameHeader(streamId, buffer.remaining(), type, flags);
            this.sink.write(buffer);
        }

        @Override
        public synchronized void settings(Settings settings) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            int length = settings.size() * 6;
            byte type = 4;
            byte flags = 0;
            int streamId = 0;
            this.frameHeader(streamId, length, type, flags);
            ByteBuffer sink = ByteBufferList.obtain(8192).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < 10; ++i) {
                if (!settings.isSet(i)) continue;
                int id = i;
                if (id == 4) {
                    id = 3;
                } else if (id == 7) {
                    id = 4;
                }
                sink.putShort((short)id);
                sink.putInt(settings.get(i));
            }
            sink.flip();
            this.sink.write(this.frameHeader.add(sink));
        }

        @Override
        public synchronized void ping(boolean ack, int payload1, int payload2) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            int length = 8;
            byte type = 6;
            byte flags = ack ? (byte)1 : 0;
            int streamId = 0;
            this.frameHeader(streamId, length, type, flags);
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(payload1);
            sink.putInt(payload2);
            sink.flip();
            this.sink.write(this.frameHeader.add(sink));
        }

        @Override
        public synchronized void goAway(int lastGoodStreamId, ErrorCode errorCode, byte[] debugData) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (errorCode.httpCode == -1) {
                throw Http20Draft13.illegalArgument("errorCode.httpCode == -1", new Object[0]);
            }
            int length = 8 + debugData.length;
            byte type = 7;
            byte flags = 0;
            int streamId = 0;
            this.frameHeader(streamId, length, type, flags);
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(lastGoodStreamId);
            sink.putInt(errorCode.httpCode);
            sink.put(debugData);
            sink.flip();
            this.sink.write(this.frameHeader.add(sink));
        }

        @Override
        public synchronized void windowUpdate(int streamId, long windowSizeIncrement) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (windowSizeIncrement == 0L || windowSizeIncrement > Integer.MAX_VALUE) {
                throw Http20Draft13.illegalArgument("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", new Object[]{windowSizeIncrement});
            }
            int length = 4;
            byte type = 8;
            byte flags = 0;
            this.frameHeader(streamId, length, type, flags);
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt((int)windowSizeIncrement);
            sink.flip();
            this.sink.write(this.frameHeader.add(sink));
        }

        @Override
        public synchronized void close() throws IOException {
            this.closed = true;
        }

        void frameHeader(int streamId, int length, byte type, byte flags) throws IOException {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(FrameLogger.formatHeader(false, streamId, length, type, flags));
            }
            if (length > 16383) {
                throw Http20Draft13.illegalArgument("FRAME_SIZE_ERROR length > %d: %d", new Object[]{16383, length});
            }
            if ((streamId & Integer.MIN_VALUE) != 0) {
                throw Http20Draft13.illegalArgument("reserved bit set: %s", new Object[]{streamId});
            }
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt((length & 0x3FFF) << 16 | (type & 0xFF) << 8 | flags & 0xFF);
            sink.putInt(streamId & Integer.MAX_VALUE);
            sink.flip();
            this.sink.write(this.frameHeader.add(sink));
        }
    }

    static final class Reader
    implements FrameReader {
        private final DataEmitter emitter;
        private final boolean client;
        private final FrameReader.Handler handler;
        private final DataEmitterReader reader;
        final HpackDraft08.Reader hpackReader;
        int w1;
        int w2;
        byte flags;
        byte type;
        short length;
        int streamId;
        private final DataCallback onFrame = new DataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                bb.order(ByteOrder.BIG_ENDIAN);
                Reader.this.w1 = bb.getInt();
                Reader.this.w2 = bb.getInt();
                Reader.this.length = (short)((Reader.this.w1 & 0x3FFF0000) >> 16);
                Reader.this.type = (byte)((Reader.this.w1 & 0xFF00) >> 8);
                Reader.this.flags = (byte)(Reader.this.w1 & 0xFF);
                Reader.this.streamId = Reader.this.w2 & Integer.MAX_VALUE;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(FrameLogger.formatHeader(true, Reader.this.streamId, Reader.this.length, Reader.this.type, Reader.this.flags));
                }
                Reader.this.reader.read(Reader.this.length, Reader.this.onFullFrame);
            }
        };
        private final DataCallback onFullFrame = new DataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                try {
                    switch (Reader.this.type) {
                        case 0: {
                            Reader.this.readData(bb, Reader.this.length, Reader.this.flags, Reader.this.streamId);
                            break;
                        }
                        case 1: {
                            Reader.this.readHeaders(bb, Reader.this.length, Reader.this.flags, Reader.this.streamId);
                            break;
                        }
                        case 2: {
                            Reader.this.readPriority(bb, Reader.this.length, Reader.this.flags, Reader.this.streamId);
                            break;
                        }
                        case 3: {
                            Reader.this.readRstStream(bb, Reader.this.length, Reader.this.flags, Reader.this.streamId);
                            break;
                        }
                        case 4: {
                            Reader.this.readSettings(bb, Reader.this.length, Reader.this.flags, Reader.this.streamId);
                            break;
                        }
                        case 5: {
                            Reader.this.readPushPromise(bb, Reader.this.length, Reader.this.flags, Reader.this.streamId);
                            break;
                        }
                        case 6: {
                            Reader.this.readPing(bb, Reader.this.length, Reader.this.flags, Reader.this.streamId);
                            break;
                        }
                        case 7: {
                            Reader.this.readGoAway(bb, Reader.this.length, Reader.this.flags, Reader.this.streamId);
                            break;
                        }
                        case 8: {
                            Reader.this.readWindowUpdate(bb, Reader.this.length, Reader.this.flags, Reader.this.streamId);
                            break;
                        }
                        case 9: {
                            Reader.this.readContinuation(bb, Reader.this.length, Reader.this.flags, Reader.this.streamId);
                            break;
                        }
                        default: {
                            bb.recycle();
                        }
                    }
                    Reader.this.parseFrameHeader();
                }
                catch (IOException e) {
                    Reader.this.handler.error(e);
                }
            }
        };
        byte pendingHeaderType;
        int continuingStreamId;
        int promisedStreamId;

        Reader(DataEmitter emitter, FrameReader.Handler handler, int headerTableSize, boolean client) {
            this.emitter = emitter;
            this.client = client;
            this.hpackReader = new HpackDraft08.Reader(headerTableSize);
            this.handler = handler;
            this.reader = new DataEmitterReader();
            this.parseFrameHeader();
        }

        private void parseFrameHeader() {
            this.emitter.setDataCallback(this.reader);
            this.reader.read(8, this.onFrame);
        }

        private void readHeaders(ByteBufferList source, short length, byte flags, int streamId) throws IOException {
            short padding;
            if (streamId == 0) {
                throw Http20Draft13.ioException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
            }
            short s = padding = (flags & 8) != 0 ? (short)(source.get() & 0xFF) : (short)0;
            if ((flags & 0x20) != 0) {
                this.readPriority(source, streamId);
                length = (short)(length - 5);
            }
            length = Http20Draft13.lengthWithoutPadding(length, flags, padding);
            this.pendingHeaderType = this.type;
            this.readHeaderBlock(source, length, padding, flags, streamId);
        }

        private void readContinuation(ByteBufferList source, short length, byte flags, int streamId) throws IOException {
            if (streamId != this.continuingStreamId) {
                throw new IOException("continuation stream id mismatch");
            }
            this.readHeaderBlock(source, length, (short)0, flags, streamId);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void readHeaderBlock(ByteBufferList source, short length, short padding, byte flags, int streamId) throws IOException {
            source.skip(padding);
            this.hpackReader.refill(source);
            this.hpackReader.readHeaders();
            this.hpackReader.emitReferenceSet();
            if ((flags & 4) != 0) {
                if (this.pendingHeaderType == 1) {
                    boolean endStream = (flags & 1) != 0;
                    this.handler.headers(false, endStream, streamId, -1, this.hpackReader.getAndReset(), HeadersMode.HTTP_20_HEADERS);
                    return;
                } else {
                    if (this.pendingHeaderType != 5) throw new AssertionError((Object)"unknown header type");
                    this.handler.pushPromise(streamId, this.promisedStreamId, this.hpackReader.getAndReset());
                }
                return;
            } else {
                this.continuingStreamId = streamId;
            }
        }

        private void readData(ByteBufferList source, short length, byte flags, int streamId) throws IOException {
            boolean gzipped;
            boolean inFinished = (flags & 1) != 0;
            boolean bl = gzipped = (flags & 0x20) != 0;
            if (gzipped) {
                throw Http20Draft13.ioException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
            }
            short padding = (flags & 8) != 0 ? (short)(source.get() & 0xFF) : (short)0;
            length = Http20Draft13.lengthWithoutPadding(length, flags, padding);
            this.handler.data(inFinished, streamId, source);
            source.skip(padding);
        }

        private void readPriority(ByteBufferList source, short length, byte flags, int streamId) throws IOException {
            if (length != 5) {
                throw Http20Draft13.ioException("TYPE_PRIORITY length: %d != 5", new Object[]{length});
            }
            if (streamId == 0) {
                throw Http20Draft13.ioException("TYPE_PRIORITY streamId == 0", new Object[0]);
            }
            this.readPriority(source, streamId);
        }

        private void readPriority(ByteBufferList source, int streamId) throws IOException {
            int w1 = source.getInt();
            boolean exclusive = (w1 & Integer.MIN_VALUE) != 0;
            int streamDependency = w1 & Integer.MAX_VALUE;
            int weight = (source.get() & 0xFF) + 1;
            this.handler.priority(streamId, streamDependency, weight, exclusive);
        }

        private void readRstStream(ByteBufferList source, short length, byte flags, int streamId) throws IOException {
            if (length != 4) {
                throw Http20Draft13.ioException("TYPE_RST_STREAM length: %d != 4", new Object[]{length});
            }
            if (streamId == 0) {
                throw Http20Draft13.ioException("TYPE_RST_STREAM streamId == 0", new Object[0]);
            }
            int errorCodeInt = source.getInt();
            ErrorCode errorCode = ErrorCode.fromHttp2(errorCodeInt);
            if (errorCode == null) {
                throw Http20Draft13.ioException("TYPE_RST_STREAM unexpected error code: %d", new Object[]{errorCodeInt});
            }
            this.handler.rstStream(streamId, errorCode);
        }

        private void readSettings(ByteBufferList source, short length, byte flags, int streamId) throws IOException {
            if (streamId != 0) {
                throw Http20Draft13.ioException("TYPE_SETTINGS streamId != 0", new Object[0]);
            }
            if ((flags & 1) != 0) {
                if (length != 0) {
                    throw Http20Draft13.ioException("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
                }
                this.handler.ackSettings();
                return;
            }
            if (length % 6 != 0) {
                throw Http20Draft13.ioException("TYPE_SETTINGS length %% 6 != 0: %s", new Object[]{(short)length});
            }
            Settings settings = new Settings();
            for (int i = 0; i < length; i += 6) {
                short id = source.getShort();
                int value = source.getInt();
                switch (id) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (value == 0 || value == 1) break;
                        throw Http20Draft13.ioException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                    }
                    case 3: {
                        id = 4;
                        break;
                    }
                    case 4: {
                        id = 7;
                        if (value >= 0) break;
                        throw Http20Draft13.ioException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                    }
                    case 5: {
                        break;
                    }
                    default: {
                        throw Http20Draft13.ioException("PROTOCOL_ERROR invalid settings id: %s", new Object[]{id});
                    }
                }
                settings.set(id, 0, value);
            }
            this.handler.settings(false, settings);
            if (settings.getHeaderTableSize() >= 0) {
                this.hpackReader.maxHeaderTableByteCountSetting(settings.getHeaderTableSize());
            }
        }

        private void readPushPromise(ByteBufferList source, short length, byte flags, int streamId) throws IOException {
            if (streamId == 0) {
                throw Http20Draft13.ioException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
            }
            short padding = (flags & 8) != 0 ? (short)(source.get() & 0xFF) : (short)0;
            this.promisedStreamId = source.getInt() & Integer.MAX_VALUE;
            length = (short)(length - 4);
            length = Http20Draft13.lengthWithoutPadding(length, flags, padding);
            this.pendingHeaderType = (byte)5;
            this.readHeaderBlock(source, length, padding, flags, streamId);
        }

        private void readPing(ByteBufferList source, short length, byte flags, int streamId) throws IOException {
            if (length != 8) {
                throw Http20Draft13.ioException("TYPE_PING length != 8: %s", new Object[]{length});
            }
            if (streamId != 0) {
                throw Http20Draft13.ioException("TYPE_PING streamId != 0", new Object[0]);
            }
            int payload1 = source.getInt();
            int payload2 = source.getInt();
            boolean ack = (flags & 1) != 0;
            this.handler.ping(ack, payload1, payload2);
        }

        private void readGoAway(ByteBufferList source, short length, byte flags, int streamId) throws IOException {
            if (length < 8) {
                throw Http20Draft13.ioException("TYPE_GOAWAY length < 8: %s", new Object[]{length});
            }
            if (streamId != 0) {
                throw Http20Draft13.ioException("TYPE_GOAWAY streamId != 0", new Object[0]);
            }
            int lastStreamId = source.getInt();
            int errorCodeInt = source.getInt();
            int opaqueDataLength = length - 8;
            ErrorCode errorCode = ErrorCode.fromHttp2(errorCodeInt);
            if (errorCode == null) {
                throw Http20Draft13.ioException("TYPE_GOAWAY unexpected error code: %d", new Object[]{errorCodeInt});
            }
            ByteString debugData = ByteString.EMPTY;
            if (opaqueDataLength > 0) {
                debugData = ByteString.of(source.getBytes(opaqueDataLength));
            }
            this.handler.goAway(lastStreamId, errorCode, debugData);
        }

        private void readWindowUpdate(ByteBufferList source, short length, byte flags, int streamId) throws IOException {
            if (length != 4) {
                throw Http20Draft13.ioException("TYPE_WINDOW_UPDATE length !=4: %s", new Object[]{length});
            }
            long increment = (long)source.getInt() & Integer.MAX_VALUE;
            if (increment == 0L) {
                throw Http20Draft13.ioException("windowSizeIncrement was 0", new Object[]{increment});
            }
            this.handler.windowUpdate(streamId, increment);
        }
    }
}

