/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.filter;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.http.filter.PrematureDataEndException;

public class ContentLengthFilter
extends FilteredDataEmitter {
    long contentLength;
    long totalRead;
    ByteBufferList transformed = new ByteBufferList();

    public ContentLengthFilter(long contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    protected void report(Exception e) {
        if (e == null && this.totalRead != this.contentLength) {
            e = new PrematureDataEndException("End of data reached before content length was read: " + this.totalRead + "/" + this.contentLength + " Paused: " + this.isPaused());
        }
        super.report(e);
    }

    @Override
    public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
        assert (this.totalRead < this.contentLength);
        int remaining = bb.remaining();
        long toRead = Math.min(this.contentLength - this.totalRead, (long)remaining);
        bb.get(this.transformed, (int)toRead);
        int beforeRead = this.transformed.remaining();
        super.onDataAvailable(emitter, this.transformed);
        this.totalRead += (long)(beforeRead - this.transformed.remaining());
        this.transformed.get(bb);
        if (this.totalRead == this.contentLength) {
            this.report(null);
        }
    }
}

