/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.future;

import com.koushikdutta.async.AsyncSemaphore;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.DependentCancellable;
import com.koushikdutta.async.future.DependentFuture;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleCancellable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SimpleFuture<T>
extends SimpleCancellable
implements DependentFuture<T> {
    AsyncSemaphore waiter;
    Exception exception;
    T result;
    boolean silent;
    FutureCallback<T> callback;

    public SimpleFuture() {
    }

    public SimpleFuture(T value) {
        this.setComplete(value);
    }

    public SimpleFuture(Exception e) {
        this.setComplete(e);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelInternal(boolean silent) {
        FutureCallback<T> callback;
        if (!super.cancel()) {
            return false;
        }
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            this.exception = new CancellationException();
            this.releaseWaiterLocked();
            callback = this.handleCompleteLocked();
            this.silent = silent;
        }
        this.handleCallbackUnlocked(callback);
        return true;
    }

    public boolean cancelSilently() {
        return this.cancelInternal(true);
    }

    @Override
    public boolean cancel() {
        return this.cancelInternal(this.silent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        AsyncSemaphore waiter;
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            if (this.isCancelled() || this.isDone()) {
                return this.getResultOrThrow();
            }
            waiter = this.ensureWaiterLocked();
        }
        waiter.acquire();
        return this.getResultOrThrow();
    }

    private T getResultOrThrow() throws ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        AsyncSemaphore waiter;
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            if (this.isCancelled() || this.isDone()) {
                return this.getResultOrThrow();
            }
            waiter = this.ensureWaiterLocked();
        }
        if (!waiter.tryAcquire(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.getResultOrThrow();
    }

    @Override
    public boolean setComplete() {
        return this.setComplete((Object)null);
    }

    private FutureCallback<T> handleCompleteLocked() {
        FutureCallback<T> callback = this.callback;
        this.callback = null;
        return callback;
    }

    private void handleCallbackUnlocked(FutureCallback<T> callback) {
        if (callback != null && !this.silent) {
            callback.onCompleted(this.exception, this.result);
        }
    }

    void releaseWaiterLocked() {
        if (this.waiter != null) {
            this.waiter.release();
            this.waiter = null;
        }
    }

    AsyncSemaphore ensureWaiterLocked() {
        if (this.waiter == null) {
            this.waiter = new AsyncSemaphore();
        }
        return this.waiter;
    }

    public boolean setComplete(Exception e) {
        return this.setComplete(e, null);
    }

    public boolean setComplete(T value) {
        return this.setComplete(null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setComplete(Exception e, T value) {
        FutureCallback<T> callback;
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            if (!super.setComplete()) {
                return false;
            }
            this.result = value;
            this.exception = e;
            this.releaseWaiterLocked();
            callback = this.handleCompleteLocked();
        }
        this.handleCallbackUnlocked(callback);
        return true;
    }

    public FutureCallback<T> getCompletionCallback() {
        return new FutureCallback<T>(){

            @Override
            public void onCompleted(Exception e, T result) {
                SimpleFuture.this.setComplete(e, result);
            }
        };
    }

    public SimpleFuture<T> setComplete(Future<T> future) {
        future.setCallback(this.getCompletionCallback());
        this.setParent(future);
        return this;
    }

    public FutureCallback<T> getCallback() {
        return this.callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFuture<T> setCallback(FutureCallback<T> callback) {
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            this.callback = callback;
            callback = this.isDone() || this.isCancelled() ? this.handleCompleteLocked() : null;
        }
        this.handleCallbackUnlocked(callback);
        return this;
    }

    @Override
    public final <C extends FutureCallback<T>> C then(C callback) {
        if (callback instanceof DependentCancellable) {
            ((DependentCancellable)((Object)callback)).setParent(this);
        }
        this.setCallback((FutureCallback)callback);
        return callback;
    }

    @Override
    public SimpleFuture<T> setParent(Cancellable parent) {
        super.setParent(parent);
        return this;
    }

    @Override
    public SimpleFuture<T> reset() {
        super.reset();
        this.result = null;
        this.exception = null;
        this.waiter = null;
        this.callback = null;
        this.silent = false;
        return this;
    }

    @Override
    public Exception tryGetException() {
        return this.exception;
    }

    @Override
    public T tryGet() {
        return this.result;
    }
}

