/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.LineEmitter;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.koushikdutta.async.http.server.UnknownRequestBody;
import java.util.regex.Matcher;

public abstract class AsyncHttpServerRequestImpl
extends FilteredDataEmitter
implements AsyncHttpServerRequest,
CompletedCallback {
    private String statusLine;
    private Headers mRawHeaders = new Headers();
    AsyncSocket mSocket;
    Matcher mMatcher;
    private CompletedCallback mReporter = new CompletedCallback(){

        @Override
        public void onCompleted(Exception error) {
            AsyncHttpServerRequestImpl.this.onCompleted(error);
        }
    };
    LineEmitter.StringCallback mHeaderCallback = new LineEmitter.StringCallback(){

        @Override
        public void onStringAvailable(String s) {
            try {
                if (AsyncHttpServerRequestImpl.this.statusLine == null) {
                    AsyncHttpServerRequestImpl.this.statusLine = s;
                    if (!AsyncHttpServerRequestImpl.this.statusLine.contains("HTTP/")) {
                        AsyncHttpServerRequestImpl.this.onNotHttp();
                        AsyncHttpServerRequestImpl.this.mSocket.setDataCallback(null);
                    }
                } else if (!"\r".equals(s)) {
                    AsyncHttpServerRequestImpl.this.mRawHeaders.addLine(s);
                } else {
                    DataEmitter emitter = HttpUtil.getBodyDecoder(AsyncHttpServerRequestImpl.this.mSocket, Protocol.HTTP_1_1, AsyncHttpServerRequestImpl.this.mRawHeaders, true);
                    AsyncHttpServerRequestImpl.this.mBody = HttpUtil.getBody(emitter, AsyncHttpServerRequestImpl.this.mReporter, AsyncHttpServerRequestImpl.this.mRawHeaders);
                    if (AsyncHttpServerRequestImpl.this.mBody == null) {
                        AsyncHttpServerRequestImpl.this.mBody = AsyncHttpServerRequestImpl.this.onUnknownBody(AsyncHttpServerRequestImpl.this.mRawHeaders);
                        if (AsyncHttpServerRequestImpl.this.mBody == null) {
                            AsyncHttpServerRequestImpl.this.mBody = new UnknownRequestBody(AsyncHttpServerRequestImpl.this.mRawHeaders.get("Content-Type"));
                        }
                    }
                    AsyncHttpServerRequestImpl.this.mBody.parse(emitter, AsyncHttpServerRequestImpl.this.mReporter);
                    AsyncHttpServerRequestImpl.this.onHeadersReceived();
                }
            }
            catch (Exception ex) {
                AsyncHttpServerRequestImpl.this.onCompleted(ex);
            }
        }
    };
    String method;
    AsyncHttpRequestBody mBody;

    public String getStatusLine() {
        return this.statusLine;
    }

    @Override
    public void onCompleted(Exception e) {
        this.report(e);
    }

    protected abstract void onHeadersReceived();

    protected void onNotHttp() {
        System.out.println("not http!");
    }

    protected AsyncHttpRequestBody onUnknownBody(Headers headers) {
        return null;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    void setSocket(AsyncSocket socket) {
        this.mSocket = socket;
        LineEmitter liner = new LineEmitter();
        this.mSocket.setDataCallback(liner);
        liner.setLineCallback(this.mHeaderCallback);
        this.mSocket.setEndCallback(new CompletedCallback.NullCompletedCallback());
    }

    @Override
    public AsyncSocket getSocket() {
        return this.mSocket;
    }

    @Override
    public Headers getHeaders() {
        return this.mRawHeaders;
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        this.mSocket.setDataCallback(callback);
    }

    @Override
    public DataCallback getDataCallback() {
        return this.mSocket.getDataCallback();
    }

    @Override
    public boolean isChunked() {
        return this.mSocket.isChunked();
    }

    @Override
    public Matcher getMatcher() {
        return this.mMatcher;
    }

    @Override
    public AsyncHttpRequestBody getBody() {
        return this.mBody;
    }

    @Override
    public void pause() {
        this.mSocket.pause();
    }

    @Override
    public void resume() {
        this.mSocket.resume();
    }

    @Override
    public boolean isPaused() {
        return this.mSocket.isPaused();
    }

    public String toString() {
        if (this.mRawHeaders == null) {
            return super.toString();
        }
        return this.mRawHeaders.toPrefixString(this.statusLine);
    }
}

