/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.net.Uri;
import android.text.TextUtils;
import com.koushikdutta.async.AsyncSSLSocket;
import com.koushikdutta.async.AsyncSSLSocketWrapper;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.LineEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncSSLEngineConfigurator;
import com.koushikdutta.async.http.AsyncSocketMiddleware;
import com.koushikdutta.async.http.libcore.RawHeaders;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;

public class AsyncSSLSocketMiddleware
extends AsyncSocketMiddleware {
    protected SSLContext sslContext;
    protected TrustManager[] trustManagers;
    protected HostnameVerifier hostnameVerifier;
    protected List<AsyncSSLEngineConfigurator> engineConfigurators = new ArrayList<AsyncSSLEngineConfigurator>();

    public AsyncSSLSocketMiddleware(AsyncHttpClient client) {
        super(client, "https", 443);
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext != null ? this.sslContext : AsyncSSLSocketWrapper.getDefaultSSLContext();
    }

    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void addEngineConfigurator(AsyncSSLEngineConfigurator engineConfigurator) {
        this.engineConfigurators.add(engineConfigurator);
    }

    public void clearEngineConfigurators() {
        this.engineConfigurators.clear();
    }

    protected SSLEngine createConfiguredSSLEngine(String host, int port) {
        SSLContext sslContext = this.getSSLContext();
        SSLEngine sslEngine = sslContext.createSSLEngine();
        for (AsyncSSLEngineConfigurator configurator : this.engineConfigurators) {
            configurator.configureEngine(sslEngine, host, port);
        }
        return sslEngine;
    }

    protected AsyncSSLSocketWrapper.HandshakeCallback createHandshakeCallback(final ConnectCallback callback) {
        return new AsyncSSLSocketWrapper.HandshakeCallback(){

            @Override
            public void onHandshakeCompleted(Exception e, AsyncSSLSocket socket) {
                callback.onConnectCompleted(e, socket);
            }
        };
    }

    protected void tryHandshake(ConnectCallback callback, AsyncSocket socket, Uri uri, int port) {
        AsyncSSLSocketWrapper.handshake(socket, uri.getHost(), port, this.createConfiguredSSLEngine(uri.getHost(), port), this.trustManagers, this.hostnameVerifier, true, this.createHandshakeCallback(callback));
    }

    @Override
    protected ConnectCallback wrapCallback(final ConnectCallback callback, final Uri uri, final int port, final boolean proxied) {
        return new ConnectCallback(){

            @Override
            public void onConnectCompleted(Exception ex, final AsyncSocket socket) {
                if (ex == null) {
                    if (!proxied) {
                        AsyncSSLSocketMiddleware.this.tryHandshake(callback, socket, uri, port);
                    } else {
                        RawHeaders connect = new RawHeaders();
                        connect.setStatusLine(String.format("CONNECT %s:%s HTTP/1.1", uri.getHost(), port));
                        Util.writeAll((DataSink)socket, connect.toHeaderString().getBytes(), new CompletedCallback(){

                            @Override
                            public void onCompleted(Exception ex) {
                                if (ex != null) {
                                    callback.onConnectCompleted(ex, socket);
                                    return;
                                }
                                LineEmitter liner = new LineEmitter();
                                liner.setLineCallback(new LineEmitter.StringCallback(){
                                    String statusLine;

                                    @Override
                                    public void onStringAvailable(String s) {
                                        if (this.statusLine == null) {
                                            this.statusLine = s;
                                            if (this.statusLine.length() > 128 || !this.statusLine.contains("200")) {
                                                socket.setDataCallback(null);
                                                socket.setEndCallback(null);
                                                callback.onConnectCompleted(new IOException("non 200 status line"), socket);
                                            }
                                        } else {
                                            socket.setDataCallback(null);
                                            socket.setEndCallback(null);
                                            if (TextUtils.isEmpty((CharSequence)s.trim())) {
                                                AsyncSSLSocketMiddleware.this.tryHandshake(callback, socket, uri, port);
                                            } else {
                                                callback.onConnectCompleted(new IOException("unknown second status line"), socket);
                                            }
                                        }
                                    }
                                });
                                socket.setDataCallback(liner);
                                socket.setEndCallback(new CompletedCallback(){

                                    @Override
                                    public void onCompleted(Exception ex) {
                                        if (!socket.isOpen() && ex == null) {
                                            ex = new IOException("socket closed before proxy connect response");
                                        }
                                        callback.onConnectCompleted(ex, socket);
                                    }
                                });
                            }
                        });
                    }
                } else {
                    callback.onConnectCompleted(ex, socket);
                }
            }
        };
    }
}

