/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.LineEmitter;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.http.libcore.RequestHeaders;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.koushikdutta.async.http.server.UnknownRequestBody;
import java.util.regex.Matcher;

public abstract class AsyncHttpServerRequestImpl
extends FilteredDataEmitter
implements AsyncHttpServerRequest,
CompletedCallback {
    private RawHeaders mRawHeaders = new RawHeaders();
    AsyncSocket mSocket;
    Matcher mMatcher;
    private CompletedCallback mReporter = new CompletedCallback(){

        @Override
        public void onCompleted(Exception error) {
            AsyncHttpServerRequestImpl.this.onCompleted(error);
        }
    };
    LineEmitter.StringCallback mHeaderCallback = new LineEmitter.StringCallback(){

        @Override
        public void onStringAvailable(String s) {
            try {
                if (AsyncHttpServerRequestImpl.this.mRawHeaders.getStatusLine() == null) {
                    AsyncHttpServerRequestImpl.this.mRawHeaders.setStatusLine(s);
                    if (!AsyncHttpServerRequestImpl.this.mRawHeaders.getStatusLine().contains("HTTP/")) {
                        AsyncHttpServerRequestImpl.this.onNotHttp();
                        AsyncHttpServerRequestImpl.this.mSocket.setDataCallback(null);
                    }
                } else if (!"\r".equals(s)) {
                    AsyncHttpServerRequestImpl.this.mRawHeaders.addLine(s);
                } else {
                    DataEmitter emitter = HttpUtil.getBodyDecoder(AsyncHttpServerRequestImpl.this.mSocket, AsyncHttpServerRequestImpl.this.mRawHeaders, true);
                    AsyncHttpServerRequestImpl.this.mBody = HttpUtil.getBody(emitter, AsyncHttpServerRequestImpl.this.mReporter, AsyncHttpServerRequestImpl.this.mRawHeaders);
                    if (AsyncHttpServerRequestImpl.this.mBody == null) {
                        AsyncHttpServerRequestImpl.this.mBody = AsyncHttpServerRequestImpl.this.onUnknownBody(AsyncHttpServerRequestImpl.this.mRawHeaders);
                        if (AsyncHttpServerRequestImpl.this.mBody == null) {
                            AsyncHttpServerRequestImpl.this.mBody = new UnknownRequestBody(AsyncHttpServerRequestImpl.this.mRawHeaders.get("Content-Type"));
                        }
                    }
                    AsyncHttpServerRequestImpl.this.mBody.parse(emitter, AsyncHttpServerRequestImpl.this.mReporter);
                    AsyncHttpServerRequestImpl.this.mHeaders = new RequestHeaders(null, AsyncHttpServerRequestImpl.this.mRawHeaders);
                    AsyncHttpServerRequestImpl.this.onHeadersReceived();
                }
            }
            catch (Exception ex) {
                AsyncHttpServerRequestImpl.this.onCompleted(ex);
            }
        }
    };
    String method;
    private RequestHeaders mHeaders;
    AsyncHttpRequestBody mBody;

    @Override
    public void onCompleted(Exception e) {
        this.report(e);
    }

    protected abstract void onHeadersReceived();

    protected void onNotHttp() {
        System.out.println("not http: " + this.mRawHeaders.getStatusLine());
        System.out.println("not http: " + this.mRawHeaders.getStatusLine().length());
    }

    protected AsyncHttpRequestBody onUnknownBody(RawHeaders headers) {
        return null;
    }

    RawHeaders getRawHeaders() {
        return this.mRawHeaders;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    void setSocket(AsyncSocket socket) {
        this.mSocket = socket;
        LineEmitter liner = new LineEmitter();
        this.mSocket.setDataCallback(liner);
        liner.setLineCallback(this.mHeaderCallback);
    }

    @Override
    public AsyncSocket getSocket() {
        return this.mSocket;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.mHeaders;
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        this.mSocket.setDataCallback(callback);
    }

    @Override
    public DataCallback getDataCallback() {
        return this.mSocket.getDataCallback();
    }

    @Override
    public boolean isChunked() {
        return this.mSocket.isChunked();
    }

    @Override
    public Matcher getMatcher() {
        return this.mMatcher;
    }

    @Override
    public AsyncHttpRequestBody getBody() {
        return this.mBody;
    }

    @Override
    public void pause() {
        this.mSocket.pause();
    }

    @Override
    public void resume() {
        this.mSocket.resume();
    }

    @Override
    public boolean isPaused() {
        return this.mSocket.isPaused();
    }
}

