/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.libcore;

import java.nio.ByteOrder;

public final class Memory {
    private Memory() {
    }

    public static int peekInt(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
        }
        return (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
    }

    public static long peekLong(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int h = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 0;
            int l = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
            return (long)h << 32 | (long)l & 0xFFFFFFFFL;
        }
        int l = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 24;
        int h = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static short peekShort(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (short)(src[offset] << 8 | src[offset + 1] & 0xFF);
        }
        return (short)(src[offset + 1] << 8 | src[offset] & 0xFF);
    }

    public static void pokeInt(byte[] dst, int offset, int value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset++] = (byte)(value >> 24 & 0xFF);
            dst[offset++] = (byte)(value >> 16 & 0xFF);
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset] = (byte)(value >> 0 & 0xFF);
        } else {
            dst[offset++] = (byte)(value >> 0 & 0xFF);
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset++] = (byte)(value >> 16 & 0xFF);
            dst[offset] = (byte)(value >> 24 & 0xFF);
        }
    }

    public static void pokeLong(byte[] dst, int offset, long value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int i = (int)(value >> 32);
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            i = (int)value;
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset] = (byte)(i >> 0 & 0xFF);
        } else {
            int i = (int)value;
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            i = (int)(value >> 32);
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset] = (byte)(i >> 24 & 0xFF);
        }
    }

    public static void pokeShort(byte[] dst, int offset, short value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset] = (byte)(value >> 0 & 0xFF);
        } else {
            dst[offset++] = (byte)(value >> 0 & 0xFF);
            dst[offset] = (byte)(value >> 8 & 0xFF);
        }
    }
}

