/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class SelectorWrapper {
    private Selector selector;
    boolean isWaking;
    Semaphore semaphore = new Semaphore(0);

    public Selector getSelector() {
        return this.selector;
    }

    public SelectorWrapper(Selector selector) {
        this.selector = selector;
    }

    public int selectNow() throws IOException {
        return this.selector.selectNow();
    }

    public void select() throws IOException {
        this.select(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(long timeout) throws IOException {
        try {
            this.semaphore.drainPermits();
            this.selector.select(timeout);
        }
        finally {
            this.semaphore.release(Integer.MAX_VALUE);
        }
    }

    public Set<SelectionKey> keys() {
        return this.selector.keys();
    }

    public Set<SelectionKey> selectedKeys() {
        return this.selector.selectedKeys();
    }

    public void close() throws IOException {
        this.selector.close();
    }

    public boolean isOpen() {
        return this.selector.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupOnce() {
        boolean selecting = !this.semaphore.tryAcquire();
        this.selector.wakeup();
        if (selecting) {
            return;
        }
        SelectorWrapper selectorWrapper = this;
        synchronized (selectorWrapper) {
            if (this.isWaking) {
                return;
            }
            this.isWaking = true;
        }
        try {
            for (int i = 0; i < 100; ++i) {
                try {
                    if (this.semaphore.tryAcquire(10L, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.selector.wakeup();
            }
        }
        finally {
            SelectorWrapper selectorWrapper2 = this;
            synchronized (selectorWrapper2) {
                this.isWaking = false;
            }
        }
    }
}

