/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.socketio.transport;

import android.net.Uri;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpGet;
import com.koushikdutta.async.http.AsyncHttpPost;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.body.StringBody;
import com.koushikdutta.async.http.socketio.transport.SocketIOTransport;

public class XHRPollingTransport
implements SocketIOTransport {
    private AsyncHttpClient client;
    private Uri sessionUrl;
    private SocketIOTransport.StringCallback stringCallback;
    private CompletedCallback closedCallback;
    private boolean connected;
    private static final String SEPARATOR = "\ufffd";

    public XHRPollingTransport(AsyncHttpClient client, String sessionUrl) {
        this.client = client;
        this.sessionUrl = Uri.parse((String)sessionUrl);
        this.doLongPolling();
        this.connected = true;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.closedCallback = handler;
    }

    @Override
    public void disconnect() {
        this.connected = false;
        this.close(null);
    }

    private void close(Exception ex) {
        if (this.closedCallback != null) {
            this.closedCallback.onCompleted(ex);
        }
    }

    @Override
    public AsyncServer getServer() {
        return this.client.getServer();
    }

    @Override
    public void send(String message) {
        if (message.startsWith("5")) {
            this.postMessage(message);
            return;
        }
        AsyncHttpPost request = new AsyncHttpPost(this.computedRequestUrl());
        request.setBody(new StringBody(message));
        this.client.executeString(request, new AsyncHttpClient.StringCallback(){

            @Override
            public void onCompleted(Exception e, AsyncHttpResponse source, String result) {
                if (e != null) {
                    XHRPollingTransport.this.close(e);
                    return;
                }
                XHRPollingTransport.this.sendResult(result);
            }
        });
    }

    private void postMessage(String message) {
        if (!message.startsWith("5")) {
            return;
        }
        AsyncHttpPost request = new AsyncHttpPost(this.computedRequestUrl());
        request.setBody(new StringBody(message));
        this.client.executeString(request, null);
    }

    private void doLongPolling() {
        this.client.executeString(new AsyncHttpGet(this.computedRequestUrl()), new AsyncHttpClient.StringCallback(){

            @Override
            public void onCompleted(Exception e, AsyncHttpResponse source, String result) {
                if (e != null) {
                    XHRPollingTransport.this.close(e);
                    return;
                }
                XHRPollingTransport.this.sendResult(result);
                XHRPollingTransport.this.doLongPolling();
            }
        });
    }

    private void sendResult(String result) {
        if (this.stringCallback == null) {
            return;
        }
        if (!result.contains(SEPARATOR)) {
            this.stringCallback.onStringAvailable(result);
            return;
        }
        String[] results = result.split(SEPARATOR);
        for (int i = 1; i < results.length; i += 2) {
            this.stringCallback.onStringAvailable(results[i + 1]);
        }
    }

    private String computedRequestUrl() {
        String currentTime = String.valueOf(System.currentTimeMillis());
        return this.sessionUrl.buildUpon().appendQueryParameter("t", currentTime).build().toString();
    }

    @Override
    public void setStringCallback(SocketIOTransport.StringCallback callback) {
        this.stringCallback = callback;
    }

    @Override
    public boolean heartbeats() {
        return false;
    }
}

