/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.body;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.LineEmitter;
import com.koushikdutta.async.NullDataCallback;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ContinuationCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.future.Continuation;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.body.FilePart;
import com.koushikdutta.async.http.body.Part;
import com.koushikdutta.async.http.body.StringPart;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.http.server.BoundaryEmitter;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;

public class MultipartFormDataBody
extends BoundaryEmitter
implements AsyncHttpRequestBody<Multimap> {
    LineEmitter liner;
    RawHeaders formData;
    ByteBufferList last;
    String lastName;
    public static final String CONTENT_TYPE = "multipart/form-data";
    String contentType = "multipart/form-data";
    MultipartCallback mCallback;
    int written;
    int totalToWrite;
    private ArrayList<Part> mParts;

    @Override
    public void parse(DataEmitter emitter, CompletedCallback completed) {
        this.setDataEmitter(emitter);
        this.setEndCallback(completed);
    }

    void handleLast() {
        if (this.last == null) {
            return;
        }
        if (this.formData == null) {
            this.formData = new RawHeaders();
        }
        this.formData.add(this.lastName, this.last.peekString());
        this.lastName = null;
        this.last = null;
    }

    public String getField(String name) {
        if (this.formData == null) {
            return null;
        }
        return this.formData.get(name);
    }

    @Override
    protected void onBoundaryEnd() {
        super.onBoundaryEnd();
        this.handleLast();
    }

    @Override
    protected void onBoundaryStart() {
        final RawHeaders headers = new RawHeaders();
        this.liner = new LineEmitter();
        this.liner.setLineCallback(new LineEmitter.StringCallback(){

            @Override
            public void onStringAvailable(String s) {
                if (!"\r".equals(s)) {
                    headers.addLine(s);
                } else {
                    MultipartFormDataBody.this.handleLast();
                    MultipartFormDataBody.this.liner = null;
                    MultipartFormDataBody.this.setDataCallback(null);
                    Part part = new Part(headers);
                    if (MultipartFormDataBody.this.mCallback != null) {
                        MultipartFormDataBody.this.mCallback.onPart(part);
                    }
                    if (MultipartFormDataBody.this.getDataCallback() == null) {
                        if (part.isFile()) {
                            MultipartFormDataBody.this.setDataCallback(new NullDataCallback());
                            return;
                        }
                        MultipartFormDataBody.this.lastName = part.getName();
                        MultipartFormDataBody.this.last = new ByteBufferList();
                        MultipartFormDataBody.this.setDataCallback(new DataCallback(){

                            @Override
                            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                                bb.get(MultipartFormDataBody.this.last);
                            }
                        });
                    }
                }
            }
        });
        this.setDataCallback(this.liner);
    }

    public MultipartFormDataBody(String[] values) {
        for (String value : values) {
            String[] splits = value.split("=");
            if (splits.length != 2 || !"boundary".equals(splits[0])) continue;
            this.setBoundary(splits[1]);
            return;
        }
        this.report(new Exception("No boundary found for multipart/form-data"));
    }

    public void setMultipartCallback(MultipartCallback callback) {
        this.mCallback = callback;
    }

    public MultipartCallback getMultipartCallback() {
        return this.mCallback;
    }

    @Override
    public void write(AsyncHttpRequest request, final DataSink sink, final CompletedCallback completed) {
        if (this.mParts == null) {
            sink.end();
            return;
        }
        Continuation c = new Continuation(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                completed.onCompleted(ex);
            }
        });
        for (final Part part : this.mParts) {
            c.add(new ContinuationCallback(){

                @Override
                public void onContinue(Continuation continuation, CompletedCallback next) throws Exception {
                    part.getRawHeaders().setStatusLine(MultipartFormDataBody.this.getBoundaryStart());
                    byte[] bytes = part.getRawHeaders().toHeaderString().getBytes();
                    Util.writeAll(sink, bytes, next);
                    MultipartFormDataBody.this.written += bytes.length;
                }
            }).add(new ContinuationCallback(){

                @Override
                public void onContinue(Continuation continuation, CompletedCallback next) throws Exception {
                    long partLength = part.length();
                    if (partLength >= 0L) {
                        MultipartFormDataBody.this.written = (int)((long)MultipartFormDataBody.this.written + partLength);
                    }
                    part.write(sink, next);
                }
            }).add(new ContinuationCallback(){

                @Override
                public void onContinue(Continuation continuation, CompletedCallback next) throws Exception {
                    byte[] bytes = "\r\n".getBytes();
                    Util.writeAll(sink, bytes, next);
                    MultipartFormDataBody.this.written += bytes.length;
                }
            });
        }
        c.add(new ContinuationCallback(){

            @Override
            public void onContinue(Continuation continuation, CompletedCallback next) throws Exception {
                byte[] bytes = MultipartFormDataBody.this.getBoundaryEnd().getBytes();
                Util.writeAll(sink, bytes, next);
                MultipartFormDataBody.this.written += bytes.length;
                assert (MultipartFormDataBody.this.written == MultipartFormDataBody.this.totalToWrite);
            }
        });
        c.start();
    }

    @Override
    public String getContentType() {
        if (this.getBoundary() == null) {
            this.setBoundary("----------------------------" + UUID.randomUUID().toString().replace("-", ""));
        }
        return "multipart/form-data; boundary=" + this.getBoundary();
    }

    @Override
    public boolean readFullyOnRequest() {
        return false;
    }

    @Override
    public int length() {
        if (this.getBoundary() == null) {
            this.setBoundary("----------------------------" + UUID.randomUUID().toString().replace("-", ""));
        }
        int length = 0;
        for (Part part : this.mParts) {
            part.getRawHeaders().setStatusLine(this.getBoundaryStart());
            if (part.length() == -1L) {
                return -1;
            }
            length = (int)((long)length + (part.length() + (long)part.getRawHeaders().toHeaderString().getBytes().length + (long)"\r\n".length()));
        }
        this.totalToWrite = length += this.getBoundaryEnd().getBytes().length;
        return this.totalToWrite;
    }

    public MultipartFormDataBody() {
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void addFilePart(String name, File file) {
        this.addPart(new FilePart(name, file));
    }

    public void addStringPart(String name, String value) {
        this.addPart(new StringPart(name, value));
    }

    public void addPart(Part part) {
        if (this.mParts == null) {
            this.mParts = new ArrayList();
        }
        this.mParts.add(part);
    }

    @Override
    public Multimap get() {
        return new Multimap(this.formData);
    }

    public static interface MultipartCallback {
        public void onPart(Part var1);
    }
}

