/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.ThreadQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class AsyncSemaphore {
    Semaphore semaphore = new Semaphore(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        ThreadQueue threadQueue = ThreadQueue.getOrCreateThreadQueue(Thread.currentThread());
        AsyncSemaphore last = threadQueue.waiter;
        threadQueue.waiter = this;
        Semaphore queueSemaphore = threadQueue.queueSemaphore;
        try {
            if (this.semaphore.tryAcquire()) {
                return;
            }
            while (true) {
                Runnable run;
                if ((run = threadQueue.remove()) != null) {
                    run.run();
                    continue;
                }
                int permits = Math.max(1, queueSemaphore.availablePermits());
                queueSemaphore.acquire(permits);
                if (this.semaphore.tryAcquire()) break;
            }
        }
        finally {
            threadQueue.waiter = last;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(long timeout, TimeUnit timeunit) throws InterruptedException {
        long timeoutMs = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        ThreadQueue threadQueue = ThreadQueue.getOrCreateThreadQueue(Thread.currentThread());
        AsyncSemaphore last = threadQueue.waiter;
        threadQueue.waiter = this;
        Semaphore queueSemaphore = threadQueue.queueSemaphore;
        try {
            if (this.semaphore.tryAcquire()) {
                boolean bl = true;
                return bl;
            }
            long start = System.currentTimeMillis();
            while (true) {
                Runnable run;
                if ((run = threadQueue.remove()) != null) {
                    run.run();
                    continue;
                }
                int permits = Math.max(1, queueSemaphore.availablePermits());
                if (!queueSemaphore.tryAcquire(permits, timeoutMs, TimeUnit.MILLISECONDS)) {
                    boolean bl = false;
                    return bl;
                }
                if (this.semaphore.tryAcquire()) {
                    boolean bl = true;
                    return bl;
                }
                if (System.currentTimeMillis() - start >= timeoutMs) break;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            threadQueue.waiter = last;
        }
    }

    public void release() {
        this.semaphore.release();
        ThreadQueue.release(this);
    }
}

