/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import android.os.Looper;
import com.koushikdutta.async.ArrayDeque;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Comparator;
import java.util.PriorityQueue;

public class ByteBufferList {
    ArrayDeque<ByteBuffer> mBuffers = new ArrayDeque();
    ByteOrder order = ByteOrder.BIG_ENDIAN;
    private int remaining = 0;
    static PriorityQueue<ByteBuffer> reclaimed = new PriorityQueue<ByteBuffer>(8, new Reclaimer());
    private static int MAX_SIZE = 0x100000;
    private static int MAX_ITEM_SIZE = 262144;
    static int currentSize = 0;
    static int maxItem = 0;
    private static final Object LOCK = new Object();
    public static final ByteBuffer EMPTY_BYTEBUFFER = ByteBuffer.allocate(0);

    public ByteOrder order() {
        return this.order;
    }

    public ByteBufferList order(ByteOrder order) {
        this.order = order;
        return this;
    }

    public ByteBufferList() {
    }

    public ByteBufferList(ByteBuffer ... b) {
        this.addAll(b);
    }

    public ByteBufferList(byte[] buf) {
        ByteBuffer b = ByteBuffer.wrap(buf);
        this.add(b);
    }

    public void addAll(ByteBuffer ... bb) {
        for (ByteBuffer b : bb) {
            this.add(b);
        }
    }

    public byte[] getAllByteArray() {
        if (this.mBuffers.size() == 1 && this.mBuffers.peek().capacity() == this.remaining()) {
            this.remaining = 0;
            return this.mBuffers.remove().array();
        }
        byte[] ret = new byte[this.remaining()];
        this.get(ret);
        return ret;
    }

    public ByteBuffer[] getAllArray() {
        ByteBuffer[] ret = new ByteBuffer[this.mBuffers.size()];
        ret = this.mBuffers.toArray(ret);
        this.mBuffers.clear();
        this.remaining = 0;
        return ret;
    }

    public boolean isEmpty() {
        return this.remaining == 0;
    }

    public int remaining() {
        return this.remaining;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public int getInt() {
        int ret = this.read(4).getInt();
        this.remaining -= 4;
        return ret;
    }

    public char getByteChar() {
        char ret = (char)this.read(1).get();
        --this.remaining;
        return ret;
    }

    public int getShort() {
        short ret = this.read(2).getShort();
        this.remaining -= 2;
        return ret;
    }

    public byte get() {
        byte ret = this.read(1).get();
        --this.remaining;
        return ret;
    }

    public long getLong() {
        long ret = this.read(8).getLong();
        this.remaining -= 8;
        return ret;
    }

    public void get(byte[] bytes) {
        this.get(bytes, 0, bytes.length);
    }

    public void get(byte[] bytes, int offset, int length) {
        if (this.remaining() < length) {
            throw new IllegalArgumentException("length");
        }
        int need = length;
        while (need > 0) {
            ByteBuffer b = this.mBuffers.peek();
            int read = Math.min(b.remaining(), need);
            b.get(bytes, offset, read);
            need -= read;
            offset += read;
            if (b.remaining() != 0) continue;
            ByteBuffer removed = this.mBuffers.remove();
            assert (b == removed);
            ByteBufferList.reclaim(b);
        }
        this.remaining -= length;
    }

    public void get(ByteBufferList into, int length) {
        if (this.remaining() < length) {
            throw new IllegalArgumentException("length");
        }
        int offset = 0;
        while (offset < length) {
            ByteBuffer b = this.mBuffers.remove();
            int remaining = b.remaining();
            if (remaining == 0) {
                ByteBufferList.reclaim(b);
                continue;
            }
            if (offset + remaining > length) {
                int need = length - offset;
                ByteBuffer subset = ByteBufferList.obtain(need);
                subset.limit(need);
                b.get(subset.array(), 0, need);
                into.add(subset);
                this.mBuffers.addFirst(b);
                assert (subset.capacity() >= need);
                assert (subset.position() == 0);
                break;
            }
            into.add(b);
            offset += remaining;
        }
        this.remaining -= length;
    }

    public void get(ByteBufferList into) {
        this.get(into, this.remaining());
    }

    public ByteBufferList get(int length) {
        ByteBufferList ret = new ByteBufferList();
        this.get(ret, length);
        return ret.order(this.order);
    }

    public ByteBuffer getAll() {
        if (this.remaining() == 0) {
            return EMPTY_BYTEBUFFER;
        }
        this.read(this.remaining());
        return this.remove();
    }

    private ByteBuffer read(int count) {
        int toRead;
        if (this.remaining() < count) {
            throw new IllegalArgumentException("count : " + this.remaining() + "/" + count);
        }
        ByteBuffer first = this.mBuffers.peek();
        while (first != null && !first.hasRemaining()) {
            ByteBufferList.reclaim(this.mBuffers.remove());
            first = this.mBuffers.peek();
        }
        if (first == null) {
            return EMPTY_BYTEBUFFER;
        }
        if (first.remaining() >= count) {
            return first.order(this.order);
        }
        Buffer ret = null;
        int retOffset = 0;
        int allocSize = 0;
        for (ByteBuffer b : this.mBuffers) {
            if (allocSize >= count) break;
            if ((ret == null || b.capacity() > ret.capacity()) && b.capacity() >= count) {
                ret = b;
                retOffset = allocSize;
            }
            allocSize += b.remaining();
        }
        if (ret != null && ret.capacity() > allocSize) {
            System.arraycopy(((ByteBuffer)ret).array(), ((ByteBuffer)ret).arrayOffset() + ret.position(), ((ByteBuffer)ret).array(), ((ByteBuffer)ret).arrayOffset() + retOffset, ret.remaining());
            int retRemaining = ret.remaining();
            ((ByteBuffer)ret).position(0);
            ((ByteBuffer)ret).limit(allocSize);
            allocSize = 0;
            while (allocSize < count) {
                ByteBuffer b;
                b = this.mBuffers.remove();
                if (b != ret) {
                    System.arraycopy(b.array(), b.arrayOffset() + b.position(), ((ByteBuffer)ret).array(), ((ByteBuffer)ret).arrayOffset() + allocSize, b.remaining());
                    allocSize += b.remaining();
                    ByteBufferList.reclaim(b);
                    continue;
                }
                allocSize += retRemaining;
            }
            this.mBuffers.addFirst((ByteBuffer)ret);
            return ((ByteBuffer)ret).order(this.order);
        }
        ret = ByteBufferList.obtain(count);
        ((ByteBuffer)ret).limit(count);
        byte[] bytes = ((ByteBuffer)ret).array();
        Buffer bb = null;
        for (int offset = 0; offset < count; offset += toRead) {
            bb = this.mBuffers.remove();
            toRead = Math.min(count - offset, bb.remaining());
            ((ByteBuffer)bb).get(bytes, offset, toRead);
            if (bb.remaining() != 0) continue;
            ByteBufferList.reclaim((ByteBuffer)bb);
            bb = null;
        }
        if (bb != null && bb.remaining() > 0) {
            this.mBuffers.addFirst((ByteBuffer)bb);
        }
        this.mBuffers.addFirst((ByteBuffer)ret);
        return ((ByteBuffer)ret).order(this.order);
    }

    public void trim() {
        this.read(0);
    }

    public void add(ByteBuffer b) {
        if (b.remaining() <= 0) {
            ByteBufferList.reclaim(b);
            return;
        }
        this.addRemaining(b.remaining());
        this.mBuffers.add(b);
        this.trim();
    }

    public void addFirst(ByteBuffer b) {
        if (b.remaining() <= 0) {
            ByteBufferList.reclaim(b);
            return;
        }
        this.addRemaining(b.remaining());
        this.mBuffers.addFirst(b);
    }

    private void addRemaining(int remaining) {
        if (this.remaining() >= 0) {
            this.remaining += remaining;
        }
    }

    public void recycle() {
        while (this.mBuffers.size() > 0) {
            ByteBufferList.reclaim(this.mBuffers.remove());
        }
        assert (this.mBuffers.size() == 0);
        this.remaining = 0;
    }

    public ByteBuffer remove() {
        ByteBuffer ret = this.mBuffers.remove();
        this.remaining -= ret.remaining();
        return ret;
    }

    public int size() {
        return this.mBuffers.size();
    }

    public void spewString() {
        System.out.println(this.peekString());
    }

    public String peekString() {
        StringBuilder builder = new StringBuilder();
        for (ByteBuffer bb : this.mBuffers) {
            builder.append(new String(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining()));
        }
        return builder.toString();
    }

    public String readString() {
        StringBuilder builder = new StringBuilder();
        while (this.mBuffers.size() > 0) {
            ByteBuffer bb = this.mBuffers.remove();
            builder.append(new String(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining()));
            ByteBufferList.reclaim(bb);
        }
        this.remaining = 0;
        return builder.toString();
    }

    private static PriorityQueue<ByteBuffer> getReclaimed() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            return null;
        }
        return reclaimed;
    }

    public static void setMaxPoolSize(int size) {
        MAX_SIZE = size;
    }

    public static void setMaxItemSize(int size) {
        MAX_ITEM_SIZE = size;
    }

    private static boolean reclaimedContains(ByteBuffer b) {
        for (ByteBuffer other : reclaimed) {
            if (other != b) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reclaim(ByteBuffer b) {
        if (b == null || b.isDirect()) {
            return;
        }
        if (b.arrayOffset() != 0 || b.array().length != b.capacity()) {
            return;
        }
        if (b.capacity() < 8192) {
            return;
        }
        if (b.capacity() > MAX_ITEM_SIZE) {
            return;
        }
        PriorityQueue<ByteBuffer> r = ByteBufferList.getReclaimed();
        if (r == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            while (currentSize > MAX_SIZE && r.size() > 0 && r.peek().capacity() < b.capacity()) {
                ByteBuffer head = (ByteBuffer)r.remove();
                currentSize -= head.capacity();
            }
            if (currentSize > MAX_SIZE) {
                return;
            }
            assert (!ByteBufferList.reclaimedContains(b));
            b.position(0);
            b.limit(b.capacity());
            r.add(b);
            assert (r.size() != 0 ^ (currentSize += b.capacity()) == 0);
            maxItem = Math.max(maxItem, b.capacity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer obtain(int size) {
        PriorityQueue<ByteBuffer> r;
        if (size <= maxItem && (r = ByteBufferList.getReclaimed()) != null) {
            Object object = LOCK;
            synchronized (object) {
                while (r.size() > 0) {
                    ByteBuffer ret = (ByteBuffer)r.remove();
                    if (r.size() == 0) {
                        maxItem = 0;
                    }
                    assert (r.size() != 0 ^ (currentSize -= ret.capacity()) == 0);
                    if (ret.capacity() < size) continue;
                    return ret;
                }
            }
        }
        ByteBuffer ret = ByteBuffer.allocate(Math.max(8192, size));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obtainArray(ByteBuffer[] arr, int size) {
        int total;
        PriorityQueue<ByteBuffer> r = ByteBufferList.getReclaimed();
        int index = 0;
        if (r != null) {
            Object object = LOCK;
            synchronized (object) {
                int needed;
                for (total = 0; r.size() > 0 && total < size && index < arr.length - 1; total += needed) {
                    ByteBuffer b = (ByteBuffer)r.remove();
                    assert (r.size() != 0 ^ (currentSize -= b.capacity()) == 0);
                    needed = Math.min(size - total, b.capacity());
                    arr[index++] = b;
                }
            }
        }
        if (total < size) {
            ByteBuffer b = ByteBuffer.allocate(Math.max(8192, size - total));
            arr[index++] = b;
        }
        for (int i = index; i < arr.length; ++i) {
            arr[i] = EMPTY_BYTEBUFFER;
        }
    }

    static class Reclaimer
    implements Comparator<ByteBuffer> {
        Reclaimer() {
        }

        @Override
        public int compare(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            if (byteBuffer.capacity() == byteBuffer2.capacity()) {
                return 0;
            }
            if (byteBuffer.capacity() > byteBuffer2.capacity()) {
                return 1;
            }
            return -1;
        }
    }
}

