/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.LineEmitter;
import com.koushikdutta.async.NullDataCallback;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.ConnectionClosedException;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.filter.ChunkedOutputFilter;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.http.libcore.ResponseHeaders;
import java.nio.ByteBuffer;

abstract class AsyncHttpResponseImpl
extends FilteredDataEmitter
implements AsyncHttpResponse {
    private AsyncHttpRequestBody mWriter;
    private CompletedCallback mReporter = new CompletedCallback(){

        @Override
        public void onCompleted(Exception error) {
            if (error != null && !AsyncHttpResponseImpl.this.mCompleted) {
                AsyncHttpResponseImpl.this.report(new ConnectionClosedException("connection closed before response completed.", error));
            } else {
                AsyncHttpResponseImpl.this.report(error);
            }
        }
    };
    LineEmitter.StringCallback mHeaderCallback = new LineEmitter.StringCallback(){
        private RawHeaders mRawHeaders = new RawHeaders();

        @Override
        public void onStringAvailable(String s) {
            try {
                if (this.mRawHeaders.getStatusLine() == null) {
                    this.mRawHeaders.setStatusLine(s);
                } else if (!"\r".equals(s)) {
                    this.mRawHeaders.addLine(s);
                } else {
                    AsyncHttpResponseImpl.this.mHeaders = new ResponseHeaders(AsyncHttpResponseImpl.this.mRequest.getUri(), this.mRawHeaders);
                    AsyncHttpResponseImpl.this.onHeadersReceived();
                    if (AsyncHttpResponseImpl.this.mSocket == null) {
                        return;
                    }
                    DataEmitter emitter = "HEAD".equalsIgnoreCase(AsyncHttpResponseImpl.this.mRequest.getMethod()) ? HttpUtil.EndEmitter.create(AsyncHttpResponseImpl.this.getServer(), null) : HttpUtil.getBodyDecoder(AsyncHttpResponseImpl.this.mSocket, this.mRawHeaders, false);
                    AsyncHttpResponseImpl.this.setDataEmitter(emitter);
                }
            }
            catch (Exception ex) {
                AsyncHttpResponseImpl.this.report(ex);
            }
        }
    };
    private AsyncHttpRequest mRequest;
    private AsyncSocket mSocket;
    ResponseHeaders mHeaders;
    boolean mCompleted = false;
    private boolean mFirstWrite = true;
    DataSink mSink;

    public AsyncSocket getSocket() {
        return this.mSocket;
    }

    @Override
    public AsyncHttpRequest getRequest() {
        return this.mRequest;
    }

    void setSocket(AsyncSocket exchange) {
        this.mSocket = exchange;
        if (this.mSocket == null) {
            return;
        }
        this.mWriter = this.mRequest.getBody();
        if (this.mWriter != null) {
            if (this.mRequest.getHeaders().getContentType() == null) {
                this.mRequest.getHeaders().setContentType(this.mWriter.getContentType());
            }
            if (this.mWriter.length() > 0) {
                this.mRequest.getHeaders().setContentLength(this.mWriter.length());
                this.mSink = this.mSocket;
            } else {
                this.mRequest.getHeaders().getHeaders().set("Transfer-Encoding", "Chunked");
                this.mSink = new ChunkedOutputFilter(this.mSocket);
            }
        } else {
            this.mSink = this.mSocket;
        }
        this.mSocket.setEndCallback(this.mReporter);
        this.mSocket.setClosedCallback(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
            }
        });
        String rs = this.mRequest.getRequestString();
        this.mRequest.logv("\n" + rs);
        Util.writeAll((DataSink)exchange, rs.getBytes(), new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                if (AsyncHttpResponseImpl.this.mWriter != null) {
                    AsyncHttpResponseImpl.this.mWriter.write(AsyncHttpResponseImpl.this.mRequest, AsyncHttpResponseImpl.this, new CompletedCallback(){

                        @Override
                        public void onCompleted(Exception ex) {
                            AsyncHttpResponseImpl.this.onRequestCompleted(ex);
                        }
                    });
                } else {
                    AsyncHttpResponseImpl.this.onRequestCompleted(null);
                }
            }
        });
        LineEmitter liner = new LineEmitter();
        exchange.setDataCallback(liner);
        liner.setLineCallback(this.mHeaderCallback);
    }

    protected void onRequestCompleted(Exception ex) {
    }

    protected abstract void onHeadersReceived();

    @Override
    protected void report(Exception e) {
        super.report(e);
        this.mSocket.setDataCallback(new NullDataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                super.onDataAvailable(emitter, bb);
                AsyncHttpResponseImpl.this.mSocket.close();
            }
        });
        this.mSocket.setWriteableCallback(null);
        this.mSocket.setClosedCallback(null);
        this.mSocket.setEndCallback(null);
        this.mCompleted = true;
    }

    public AsyncHttpResponseImpl(AsyncHttpRequest request) {
        this.mRequest = request;
    }

    @Override
    public ResponseHeaders getHeaders() {
        return this.mHeaders;
    }

    private void assertContent() {
        if (!this.mFirstWrite) {
            return;
        }
        this.mFirstWrite = false;
        assert (null != this.mRequest.getHeaders().getHeaders().get("Content-Type"));
        assert (this.mRequest.getHeaders().getHeaders().get("Transfer-Encoding") != null || this.mRequest.getHeaders().getContentLength() != -1);
    }

    @Override
    public void write(ByteBuffer bb) {
        this.assertContent();
        this.mSink.write(bb);
    }

    @Override
    public void write(ByteBufferList bb) {
        this.assertContent();
        this.mSink.write(bb);
    }

    @Override
    public void end() {
        this.write(ByteBuffer.wrap(new byte[0]));
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mSink.setWriteableCallback(handler);
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mSink.getWriteableCallback();
    }

    @Override
    public boolean isOpen() {
        return this.mSink.isOpen();
    }

    @Override
    public void close() {
        this.mSink.close();
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mSink.setClosedCallback(handler);
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mSink.getClosedCallback();
    }

    @Override
    public AsyncServer getServer() {
        return this.mSocket.getServer();
    }
}

