/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.socketio;

import android.os.Handler;
import android.text.TextUtils;
import com.koushikdutta.async.NullDataCallback;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.future.DependentCancellable;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.socketio.Acknowledge;
import com.koushikdutta.async.http.socketio.ConnectCallback;
import com.koushikdutta.async.http.socketio.DisconnectCallback;
import com.koushikdutta.async.http.socketio.ErrorCallback;
import com.koushikdutta.async.http.socketio.JSONCallback;
import com.koushikdutta.async.http.socketio.ReconnectCallback;
import com.koushikdutta.async.http.socketio.SocketIOClient;
import com.koushikdutta.async.http.socketio.SocketIORequest;
import com.koushikdutta.async.http.socketio.StringCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import org.json.JSONArray;
import org.json.JSONObject;

class SocketIOConnection {
    Handler handler;
    AsyncHttpClient httpClient;
    int heartbeat;
    ArrayList<SocketIOClient> clients = new ArrayList();
    WebSocket webSocket;
    SocketIORequest request;
    Hashtable<String, Acknowledge> acknowledges = new Hashtable();
    int ackCount;
    long reconnectDelay = 1000L;

    public SocketIOConnection(Handler handler, AsyncHttpClient httpClient, SocketIORequest request) {
        this.handler = handler;
        this.httpClient = httpClient;
        this.request = request;
    }

    public boolean isConnected() {
        return this.webSocket != null && this.webSocket.isOpen();
    }

    public void emitRaw(int type, SocketIOClient client, String message, Acknowledge acknowledge) {
        String ack = "";
        if (acknowledge != null) {
            String id = "" + this.ackCount++;
            ack = id + "+";
            this.acknowledges.put(id, acknowledge);
        }
        this.webSocket.send(String.format("%d:%s:%s:%s", type, ack, client.endpoint, message));
    }

    public void connect(SocketIOClient client) {
        this.clients.add(client);
        this.webSocket.send(String.format("1::%s", client.endpoint));
    }

    public void disconnect(SocketIOClient client) {
        this.clients.remove(client);
        boolean needsEndpointDisconnect = true;
        for (SocketIOClient other : this.clients) {
            if (!TextUtils.equals((CharSequence)other.endpoint, (CharSequence)client.endpoint) && !TextUtils.isEmpty((CharSequence)client.endpoint)) continue;
            needsEndpointDisconnect = false;
            break;
        }
        if (needsEndpointDisconnect) {
            this.webSocket.send(String.format("0::%s", client.endpoint));
        }
        if (this.clients.size() > 0) {
            return;
        }
        this.webSocket.setStringCallback(null);
        this.webSocket.setClosedCallback(null);
        this.webSocket.close();
        this.webSocket = null;
    }

    void reconnect(final DependentCancellable child) {
        if (this.isConnected()) {
            return;
        }
        this.request.setHandler(null);
        Future<String> cancel = this.httpClient.executeString(this.request, new AsyncHttpClient.StringCallback(){

            @Override
            public void onCompleted(Exception e, AsyncHttpResponse response, String result) {
                if (e != null) {
                    SocketIOConnection.this.reportDisconnect(e);
                    return;
                }
                try {
                    String[] parts = result.split(":");
                    String session = parts[0];
                    SocketIOConnection.this.heartbeat = !"".equals(parts[1]) ? Integer.parseInt(parts[1]) / 2 * 1000 : 0;
                    String transportsLine = parts[3];
                    String[] transports = transportsLine.split(",");
                    HashSet<String> set = new HashSet<String>(Arrays.asList(transports));
                    if (!set.contains("websocket")) {
                        throw new Exception("websocket not supported");
                    }
                    String sessionUrl = SocketIOConnection.this.request.getUri().toString() + "websocket/" + session + "/";
                    Future<WebSocket> cancel = SocketIOConnection.this.httpClient.websocket(sessionUrl, null, new AsyncHttpClient.WebSocketConnectCallback(){

                        @Override
                        public void onCompleted(Exception ex, WebSocket webSocket) {
                            if (ex != null) {
                                SocketIOConnection.this.reportDisconnect(ex);
                                return;
                            }
                            SocketIOConnection.this.reconnectDelay = 1000L;
                            SocketIOConnection.this.webSocket = webSocket;
                            SocketIOConnection.this.attach();
                        }
                    });
                    if (child != null) {
                        child.setParent(cancel);
                    }
                }
                catch (Exception ex) {
                    SocketIOConnection.this.reportDisconnect(ex);
                }
            }
        });
        if (child != null) {
            child.setParent(cancel);
        }
    }

    void setupHeartbeat() {
        final WebSocket ws = this.webSocket;
        Runnable heartbeatRunner = new Runnable(){

            @Override
            public void run() {
                if (SocketIOConnection.this.heartbeat <= 0 || ws != SocketIOConnection.this.webSocket || ws == null || !ws.isOpen()) {
                    return;
                }
                SocketIOConnection.this.webSocket.send("2:::");
                SocketIOConnection.this.webSocket.getServer().postDelayed(this, SocketIOConnection.this.heartbeat);
            }
        };
        heartbeatRunner.run();
    }

    private void select(String endpoint, SelectCallback callback) {
        for (SocketIOClient client : this.clients) {
            if (endpoint != null && !TextUtils.equals((CharSequence)client.endpoint, (CharSequence)endpoint)) continue;
            callback.onSelect(client);
        }
    }

    private void delayReconnect() {
        if (this.webSocket != null || this.clients.size() == 0) {
            return;
        }
        boolean disconnected = false;
        for (SocketIOClient client : this.clients) {
            if (!client.disconnected) continue;
            disconnected = true;
            break;
        }
        if (!disconnected) {
            return;
        }
        this.httpClient.getServer().postDelayed(new Runnable(){

            @Override
            public void run() {
                SocketIOConnection.this.reconnect(null);
            }
        }, this.reconnectDelay);
        this.reconnectDelay *= 2L;
    }

    private void reportDisconnect(final Exception ex) {
        this.select(null, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                if (client.connected) {
                    client.disconnected = true;
                    DisconnectCallback closed = client.getDisconnectCallback();
                    if (closed != null) {
                        closed.onDisconnect(ex);
                    }
                } else {
                    ConnectCallback callback = client.connectCallback;
                    if (callback != null) {
                        callback.onConnectCompleted(ex, client);
                    }
                }
            }
        });
        this.delayReconnect();
    }

    private void reportConnect(String endpoint) {
        this.select(endpoint, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                if (client.isConnected()) {
                    return;
                }
                if (!client.connected) {
                    client.connected = true;
                    ConnectCallback callback = client.connectCallback;
                    if (callback != null) {
                        callback.onConnectCompleted(null, client);
                    }
                } else if (client.disconnected) {
                    client.disconnected = false;
                    ReconnectCallback callback = client.reconnectCallback;
                    if (callback != null) {
                        callback.onReconnect();
                    }
                }
            }
        });
    }

    private void reportJson(String endpoint, final JSONObject jsonMessage, final Acknowledge acknowledge) {
        this.select(endpoint, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                JSONCallback callback = client.jsonCallback;
                if (callback != null) {
                    callback.onJSON(jsonMessage, acknowledge);
                }
            }
        });
    }

    private void reportString(String endpoint, final String string, final Acknowledge acknowledge) {
        this.select(endpoint, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                StringCallback callback = client.stringCallback;
                if (callback != null) {
                    callback.onString(string, acknowledge);
                }
            }
        });
    }

    private void reportEvent(String endpoint, final String event, final JSONArray arguments, final Acknowledge acknowledge) {
        this.select(endpoint, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                client.onEvent(event, arguments, acknowledge);
            }
        });
    }

    private void reportError(String endpoint, final String error) {
        this.select(endpoint, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                ErrorCallback callback = client.errorCallback;
                if (callback != null) {
                    callback.onError(error);
                }
            }
        });
    }

    private Acknowledge acknowledge(final String messageId) {
        if (TextUtils.isEmpty((CharSequence)messageId)) {
            return null;
        }
        return new Acknowledge(){

            @Override
            public void acknowledge(JSONArray arguments) {
                String data = "";
                if (arguments != null) {
                    data = data + "+" + arguments.toString();
                }
                SocketIOConnection.this.webSocket.send(String.format("6:::%s%s", messageId, data));
            }
        };
    }

    private void attach() {
        this.setupHeartbeat();
        this.webSocket.setDataCallback(new NullDataCallback());
        this.webSocket.setClosedCallback(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                SocketIOConnection.this.webSocket = null;
                SocketIOConnection.this.reportDisconnect(ex);
            }
        });
        this.webSocket.setStringCallback(new WebSocket.StringCallback(){

            @Override
            public void onStringAvailable(String message) {
                try {
                    String[] parts = message.split(":", 4);
                    int code = Integer.parseInt(parts[0]);
                    switch (code) {
                        case 0: {
                            SocketIOConnection.this.webSocket.close();
                            SocketIOConnection.this.reportDisconnect(null);
                            break;
                        }
                        case 1: {
                            SocketIOConnection.this.reportConnect(parts[2]);
                            break;
                        }
                        case 2: {
                            SocketIOConnection.this.webSocket.send("2::");
                            break;
                        }
                        case 3: {
                            SocketIOConnection.this.reportString(parts[2], parts[3], SocketIOConnection.this.acknowledge(parts[1]));
                            break;
                        }
                        case 4: {
                            String dataString = parts[3];
                            JSONObject jsonMessage = new JSONObject(dataString);
                            SocketIOConnection.this.reportJson(parts[2], jsonMessage, SocketIOConnection.this.acknowledge(parts[1]));
                            break;
                        }
                        case 5: {
                            String dataString = parts[3];
                            JSONObject data = new JSONObject(dataString);
                            String event = data.getString("name");
                            JSONArray args = data.optJSONArray("args");
                            SocketIOConnection.this.reportEvent(parts[2], event, args, SocketIOConnection.this.acknowledge(parts[1]));
                            break;
                        }
                        case 6: {
                            String[] ackParts = parts[3].split("\\+", 2);
                            Acknowledge ack = SocketIOConnection.this.acknowledges.remove(ackParts[0]);
                            if (ack == null) {
                                return;
                            }
                            JSONArray arguments = null;
                            if (ackParts.length == 2) {
                                arguments = new JSONArray(ackParts[1]);
                            }
                            ack.acknowledge(arguments);
                            break;
                        }
                        case 7: {
                            SocketIOConnection.this.reportError(parts[2], parts[3]);
                            break;
                        }
                        case 8: {
                            break;
                        }
                        default: {
                            throw new Exception("unknown code");
                        }
                    }
                }
                catch (Exception ex) {
                    SocketIOConnection.this.webSocket.setClosedCallback(null);
                    SocketIOConnection.this.webSocket.close();
                    SocketIOConnection.this.webSocket = null;
                    SocketIOConnection.this.reportDisconnect(ex);
                }
            }
        });
    }

    private static interface SelectCallback {
        public void onSelect(SocketIOClient var1);
    }
}

