/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.ChannelWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

class SocketChannelWrapper
extends ChannelWrapper {
    SocketChannel mChannel;

    @Override
    public int getLocalPort() {
        return this.mChannel.socket().getLocalPort();
    }

    SocketChannelWrapper(SocketChannel channel) throws IOException {
        super(channel);
        this.mChannel = channel;
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        return this.mChannel.read(buffer);
    }

    @Override
    public boolean isConnected() {
        return this.mChannel.isConnected();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.mChannel.write(src);
    }

    @Override
    public int write(ByteBuffer[] src) throws IOException {
        return (int)this.mChannel.write(src);
    }

    @Override
    public SelectionKey register(Selector sel) throws ClosedChannelException {
        return this.register(sel, 8);
    }

    @Override
    public void shutdownOutput() {
        try {
            this.mChannel.socket().shutdownOutput();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void shutdownInput() {
        try {
            this.mChannel.socket().shutdownInput();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long read(ByteBuffer[] byteBuffers) throws IOException {
        return this.mChannel.read(byteBuffers);
    }

    @Override
    public long read(ByteBuffer[] byteBuffers, int i, int i2) throws IOException {
        return this.mChannel.read(byteBuffers, i, i2);
    }
}

