/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.wrapper.AsyncSocketWrapper;
import com.koushikdutta.async.wrapper.DataEmitterWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class Util {
    public static void emitAllData(DataEmitter emitter, ByteBufferList list) {
        int remaining;
        DataCallback handler = null;
        while (!emitter.isPaused() && (handler = emitter.getDataCallback()) != null && (remaining = list.remaining()) > 0) {
            handler.onDataAvailable(emitter, list);
            if (remaining != list.remaining() || handler != emitter.getDataCallback()) continue;
            System.out.println("Data: " + list.peekString());
            System.out.println("handler: " + handler);
            assert (false);
            throw new RuntimeException("mDataHandler failed to consume data, yet remains the mDataHandler.");
        }
        if (list.remaining() != 0 && !emitter.isPaused()) {
            System.out.println("Data: " + list.peekString());
            System.out.println("handler: " + handler);
            assert (false);
            throw new RuntimeException("mDataHandler failed to consume data, yet remains the mDataHandler.");
        }
    }

    public static void pump(final InputStream is, final DataSink ds, final CompletedCallback callback) {
        final CompletedCallback wrapper = new CompletedCallback(){
            boolean reported;

            @Override
            public void onCompleted(Exception ex) {
                if (this.reported) {
                    return;
                }
                this.reported = true;
                callback.onCompleted(ex);
            }
        };
        WritableCallback cb = new WritableCallback(){
            byte[] buffer = new byte[8192];
            ByteBuffer pending = ByteBuffer.wrap(this.buffer);
            {
                this.pending.limit(this.pending.position());
            }

            private void close() {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onWriteable() {
                try {
                    int remaining;
                    do {
                        if (this.pending.remaining() == 0) {
                            int read = is.read(this.buffer);
                            if (read == -1) {
                                this.close();
                                wrapper.onCompleted(null);
                                return;
                            }
                            this.pending.position(0);
                            this.pending.limit(read);
                        }
                        remaining = this.pending.remaining();
                        ds.write(this.pending);
                    } while (remaining != this.pending.remaining());
                }
                catch (Exception e) {
                    this.close();
                    wrapper.onCompleted(e);
                }
            }
        };
        ds.setWriteableCallback(cb);
        ds.setClosedCallback(wrapper);
        cb.onWriteable();
    }

    public static void pump(final DataEmitter emitter, final DataSink sink, final CompletedCallback callback) {
        emitter.setDataCallback(new DataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                sink.write(bb);
                if (bb.remaining() > 0) {
                    emitter.pause();
                }
            }
        });
        sink.setWriteableCallback(new WritableCallback(){

            @Override
            public void onWriteable() {
                emitter.resume();
            }
        });
        CompletedCallback wrapper = new CompletedCallback(){
            boolean reported;

            @Override
            public void onCompleted(Exception ex) {
                if (this.reported) {
                    return;
                }
                this.reported = true;
                callback.onCompleted(ex);
            }
        };
        emitter.setEndCallback(wrapper);
        sink.setClosedCallback(wrapper);
    }

    public static void stream(AsyncSocket s1, AsyncSocket s2, CompletedCallback callback) {
        Util.pump(s1, (DataSink)s2, callback);
        Util.pump(s2, (DataSink)s1, callback);
    }

    public static void pump(File file, DataSink ds, final CompletedCallback callback) {
        try {
            if (file == null || ds == null) {
                callback.onCompleted(null);
                return;
            }
            final FileInputStream is = new FileInputStream(file);
            Util.pump(is, ds, new CompletedCallback(){

                @Override
                public void onCompleted(Exception ex) {
                    try {
                        is.close();
                        callback.onCompleted(ex);
                    }
                    catch (IOException e) {
                        callback.onCompleted(e);
                    }
                }
            });
        }
        catch (Exception e) {
            callback.onCompleted(e);
        }
    }

    public static void writeAll(final DataSink sink, final ByteBufferList bb, final CompletedCallback callback) {
        int total = bb.remaining();
        WritableCallback wc = new WritableCallback(){

            @Override
            public void onWriteable() {
                if (bb.remaining() > 0) {
                    sink.write(bb);
                }
                if (bb.remaining() == 0 && callback != null) {
                    callback.onCompleted(null);
                }
            }
        };
        sink.setWriteableCallback(wc);
        wc.onWriteable();
    }

    public static void writeAll(DataSink sink, byte[] bytes, CompletedCallback callback) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        ByteBufferList bbl = new ByteBufferList();
        bbl.add(bb);
        Util.writeAll(sink, bbl, callback);
    }

    public static AsyncSocket getWrappedSocket(AsyncSocket socket, Class wrappedClass) {
        if (wrappedClass.isInstance(socket)) {
            return socket;
        }
        while (socket instanceof AsyncSocketWrapper) {
            if (!wrappedClass.isInstance(socket = ((AsyncSocketWrapper)socket).getSocket())) continue;
            return socket;
        }
        return null;
    }

    public static DataEmitter getWrappedDataEmitter(DataEmitter emitter, Class wrappedClass) {
        if (wrappedClass.isInstance(emitter)) {
            return emitter;
        }
        while (emitter instanceof DataEmitterWrapper) {
            if (!wrappedClass.isInstance(emitter = ((AsyncSocketWrapper)emitter).getSocket())) continue;
            return emitter;
        }
        return null;
    }
}

