/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import android.util.Log;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.ChannelWrapper;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DatagramChannelWrapper;
import com.koushikdutta.async.SocketChannelWrapper;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.WritableCallback;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class AsyncNetworkSocket
implements AsyncSocket {
    InetSocketAddress socketAddress;
    private ChannelWrapper mChannel;
    private SelectionKey mKey;
    private AsyncServer mServer;
    private ByteBufferList pending;
    int maxAlloc;
    int mToAlloc = 0;
    boolean closeReported;
    WritableCallback mWriteableHandler;
    DataCallback mDataHandler;
    CompletedCallback mClosedHander;
    boolean mEndReported;
    Exception mPendingEndException;
    private CompletedCallback mCompletedCallback;
    boolean mPaused = false;

    AsyncNetworkSocket() {
    }

    @Override
    public void end() {
        this.mChannel.shutdownOutput();
    }

    @Override
    public boolean isChunked() {
        return this.mChannel.isChunked();
    }

    void attach(SocketChannel channel, InetSocketAddress socketAddress) throws IOException {
        this.socketAddress = socketAddress;
        this.maxAlloc = 262144;
        this.mChannel = new SocketChannelWrapper(channel);
    }

    void attach(DatagramChannel channel) throws IOException {
        this.mChannel = new DatagramChannelWrapper(channel);
        this.maxAlloc = 8192;
    }

    ChannelWrapper getChannel() {
        return this.mChannel;
    }

    public void onDataWritable() {
        assert (this.mWriteableHandler != null);
        this.mWriteableHandler.onWriteable();
    }

    void setup(AsyncServer server, SelectionKey key) {
        this.mServer = server;
        this.mKey = key;
    }

    @Override
    public void write(final ByteBufferList list) {
        if (this.mServer.getAffinity() != Thread.currentThread()) {
            this.mServer.run(new Runnable(){

                @Override
                public void run() {
                    AsyncNetworkSocket.this.write(list);
                }
            });
            return;
        }
        if (!this.mChannel.isConnected()) {
            assert (!this.mChannel.isChunked());
            return;
        }
        try {
            ByteBuffer[] arr = list.getAllArray();
            this.mChannel.write(arr);
            list.addAll(arr);
            this.handleRemaining(list.remaining());
        }
        catch (IOException e) {
            this.close();
            this.reportEndPending(e);
            this.reportClose(e);
        }
    }

    private void handleRemaining(int remaining) {
        if (remaining > 0) {
            assert (!this.mChannel.isChunked());
            this.mKey.interestOps(5);
        } else {
            this.mKey.interestOps(1);
        }
    }

    @Override
    public void write(final ByteBuffer b) {
        if (this.mServer.getAffinity() != Thread.currentThread()) {
            this.mServer.run(new Runnable(){

                @Override
                public void run() {
                    AsyncNetworkSocket.this.write(b);
                }
            });
            return;
        }
        try {
            if (!this.mChannel.isConnected()) {
                assert (!this.mChannel.isChunked());
                return;
            }
            this.mChannel.write(b);
            this.handleRemaining(b.remaining());
        }
        catch (IOException ex) {
            this.close();
            this.reportEndPending(ex);
            this.reportClose(ex);
        }
    }

    int onReadable() {
        this.spitPending();
        if (this.mPaused) {
            return 0;
        }
        int total = 0;
        try {
            boolean closed = false;
            ByteBuffer b = ByteBufferList.obtain(Math.min(Math.max(this.mToAlloc, 4096), this.maxAlloc));
            int read = this.mChannel.read(b);
            if (read < 0) {
                this.closeInternal();
                closed = true;
            } else {
                total += read;
            }
            if (read > 0) {
                this.mToAlloc = read * 2;
                b.limit(b.position());
                b.position(0);
                ByteBufferList list = new ByteBufferList(b);
                Util.emitAllData((DataEmitter)this, list);
                if (b.remaining() != 0) {
                    assert (this.pending == null);
                    this.pending = list;
                }
            }
            if (closed) {
                this.reportEndPending(null);
                this.reportClose(null);
            }
        }
        catch (Exception e) {
            this.closeInternal();
            this.reportEndPending(e);
            this.reportClose(e);
        }
        return total;
    }

    protected void reportClose(Exception e) {
        if (this.closeReported) {
            return;
        }
        this.closeReported = true;
        if (this.mClosedHander != null) {
            this.mClosedHander.onCompleted(e);
            this.mClosedHander = null;
        }
    }

    @Override
    public void close() {
        this.closeInternal();
        this.reportClose(null);
    }

    public void closeInternal() {
        this.mKey.cancel();
        try {
            this.mChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mWriteableHandler = handler;
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        this.mDataHandler = callback;
    }

    @Override
    public DataCallback getDataCallback() {
        return this.mDataHandler;
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mClosedHander = handler;
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mClosedHander;
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mWriteableHandler;
    }

    void reportEnd(Exception e) {
        if (this.mEndReported) {
            return;
        }
        this.mEndReported = true;
        if (this.mCompletedCallback != null) {
            this.mCompletedCallback.onCompleted(e);
        } else if (e != null) {
            Log.e((String)"NIO", (String)"Unhandled exception", (Throwable)e);
        }
    }

    void reportEndPending(Exception e) {
        if (this.pending != null) {
            this.mPendingEndException = e;
            return;
        }
        this.reportEnd(e);
    }

    @Override
    public void setEndCallback(CompletedCallback callback) {
        this.mCompletedCallback = callback;
    }

    @Override
    public CompletedCallback getEndCallback() {
        return this.mCompletedCallback;
    }

    @Override
    public boolean isOpen() {
        return this.mChannel.isConnected() && this.mKey.isValid();
    }

    @Override
    public void pause() {
        if (this.mServer.getAffinity() != Thread.currentThread()) {
            this.mServer.run(new Runnable(){

                @Override
                public void run() {
                    AsyncNetworkSocket.this.pause();
                }
            });
            return;
        }
        if (this.mPaused) {
            return;
        }
        this.mPaused = true;
        try {
            this.mKey.interestOps(0xFFFFFFFE & this.mKey.interestOps());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void spitPending() {
        if (this.pending != null) {
            Util.emitAllData((DataEmitter)this, this.pending);
            if (this.pending.remaining() == 0) {
                this.pending = null;
            }
        }
    }

    @Override
    public void resume() {
        if (this.mServer.getAffinity() != Thread.currentThread()) {
            this.mServer.run(new Runnable(){

                @Override
                public void run() {
                    AsyncNetworkSocket.this.resume();
                }
            });
            return;
        }
        if (!this.mPaused) {
            return;
        }
        this.mPaused = false;
        try {
            this.mKey.interestOps(1 | this.mKey.interestOps());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.spitPending();
        if (!this.isOpen()) {
            this.reportEndPending(this.mPendingEndException);
        }
    }

    @Override
    public boolean isPaused() {
        return this.mPaused;
    }

    @Override
    public AsyncServer getServer() {
        return this.mServer;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.socketAddress;
    }

    public int getLocalPort() {
        return this.mChannel.getLocalPort();
    }
}

