/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.filter;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FilteredDataEmitter;

public class ContentLengthFilter
extends FilteredDataEmitter {
    int contentLength;
    int totalRead;

    public ContentLengthFilter(int contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
        assert (this.totalRead < this.contentLength);
        int remaining = bb.remaining();
        int toRead = Math.min(this.contentLength - this.totalRead, remaining);
        ByteBufferList list = toRead == remaining ? bb : bb.get(toRead);
        this.totalRead += list.remaining();
        super.onDataAvailable(emitter, list);
        if (this.totalRead == this.contentLength) {
            this.report(null);
        }
    }
}

