/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.future;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.DependentFuture;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleCancellable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SimpleFuture<T>
extends SimpleCancellable
implements DependentFuture<T> {
    AsyncServer.AsyncSemaphore waiter;
    Exception exception;
    T result;
    FutureCallback<T> callback;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        if (super.cancel()) {
            SimpleFuture simpleFuture = this;
            synchronized (simpleFuture) {
                this.exception = new CancellationException();
                if (this.waiter != null) {
                    this.waiter.release();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            if (this.isCancelled() || this.isDone()) {
                return this.getResult();
            }
            if (this.waiter == null) {
                this.waiter = new AsyncServer.AsyncSemaphore();
            }
        }
        this.waiter.acquire();
        return this.getResult();
    }

    private T getResult() throws ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            if (this.isCancelled() || this.isDone()) {
                return this.getResult();
            }
            if (this.waiter == null) {
                this.waiter = new AsyncServer.AsyncSemaphore();
            }
        }
        if (!this.waiter.tryAcquire(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.getResult();
    }

    @Override
    public boolean setComplete() {
        return this.setComplete((Object)null);
    }

    private FutureCallback<T> handleCompleteLocked() {
        FutureCallback<T> callback = this.callback;
        this.callback = null;
        return callback;
    }

    private void handleCallbackUnlocked(FutureCallback<T> callback) {
        if (callback != null) {
            callback.onCompleted(this.exception, this.result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setComplete(Exception e) {
        FutureCallback<T> callback;
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            if (!super.setComplete()) {
                return false;
            }
            if (this.waiter != null) {
                this.waiter.release();
            }
            this.exception = e;
            callback = this.handleCompleteLocked();
        }
        this.handleCallbackUnlocked(callback);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setComplete(T value) {
        FutureCallback<T> callback;
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            if (!super.setComplete()) {
                return false;
            }
            this.result = value;
            if (this.waiter != null) {
                this.waiter.release();
            }
            callback = this.handleCompleteLocked();
        }
        this.handleCallbackUnlocked(callback);
        return true;
    }

    public boolean setComplete(Exception e, T value) {
        if (e != null) {
            return this.setComplete(e);
        }
        return this.setComplete(value);
    }

    public FutureCallback<T> getCompletionCallback() {
        return new FutureCallback<T>(){

            @Override
            public void onCompleted(Exception e, T result) {
                SimpleFuture.this.setComplete(e, result);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFuture<T> setCallback(FutureCallback<T> callback) {
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            this.callback = callback;
            callback = this.isDone() ? this.handleCompleteLocked() : null;
        }
        this.handleCallbackUnlocked(callback);
        return this;
    }

    @Override
    public SimpleFuture<T> setParent(Cancellable parent) {
        super.setParent(parent);
        return this;
    }
}

