/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.BufferedDataSink;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataSink;
import java.nio.ByteBuffer;

public class FilteredDataSink
extends BufferedDataSink {
    public FilteredDataSink(DataSink sink) {
        super(sink);
        this.setMaxBuffer(0);
    }

    public ByteBufferList filter(ByteBufferList bb) {
        return bb;
    }

    @Override
    public final void write(ByteBuffer bb) {
        if (this.isBuffering() && this.getMaxBuffer() != Integer.MAX_VALUE) {
            return;
        }
        ByteBufferList list = new ByteBufferList();
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes);
        assert (bb.remaining() == 0);
        list.add(ByteBuffer.wrap(bytes));
        ByteBufferList filtered = this.filter(list);
        super.write(filtered, true);
    }

    @Override
    public final void write(ByteBufferList bb) {
        if (this.isBuffering() && this.getMaxBuffer() != Integer.MAX_VALUE) {
            return;
        }
        ByteBufferList filtered = this.filter(bb);
        assert (bb == null || filtered == bb || bb.isEmpty());
        super.write(filtered, true);
        if (bb != null) {
            bb.clear();
        }
    }
}

