/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.callback.DataCallback;

public class DataEmitterReader
implements DataCallback {
    DataCallback mPendingRead;
    int mPendingReadLength;
    ByteBufferList mPendingData = new ByteBufferList();

    public void read(int count, DataCallback callback) {
        assert (this.mPendingRead == null);
        this.mPendingReadLength = count;
        this.mPendingRead = callback;
        this.mPendingData = new ByteBufferList();
    }

    private boolean handlePendingData(DataEmitter emitter) {
        if (this.mPendingReadLength > this.mPendingData.remaining()) {
            return false;
        }
        DataCallback pendingRead = this.mPendingRead;
        this.mPendingRead = null;
        pendingRead.onDataAvailable(emitter, this.mPendingData);
        return true;
    }

    @Override
    public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
        assert (this.mPendingRead != null);
        do {
            int need = Math.min(bb.remaining(), this.mPendingReadLength - this.mPendingData.remaining());
            bb.get(this.mPendingData, need);
        } while (this.handlePendingData(emitter) && this.mPendingRead != null);
    }
}

