/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import com.koushikdutta.async.AsyncSSLSocketWrapper;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncSocketMiddleware;
import java.net.URI;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class AsyncSSLSocketMiddleware
extends AsyncSocketMiddleware {
    SSLContext sslContext;
    TrustManager[] trustManagers;

    public AsyncSSLSocketMiddleware(AsyncHttpClient client) {
        super(client, "https", 443);
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }

    @Override
    protected ConnectCallback wrapCallback(final ConnectCallback callback, final URI uri, final int port) {
        return new ConnectCallback(){

            @Override
            public void onConnectCompleted(Exception ex, AsyncSocket socket) {
                if (ex == null) {
                    callback.onConnectCompleted(ex, new AsyncSSLSocketWrapper(socket, uri.getHost(), port, AsyncSSLSocketMiddleware.this.sslContext, AsyncSSLSocketMiddleware.this.trustManagers, true));
                } else {
                    callback.onConnectCompleted(ex, socket);
                }
            }
        };
    }
}

