/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import android.content.Context;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncServerSocket;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ListenCallback;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.WebSocketImpl;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.http.libcore.RequestHeaders;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.koushikdutta.async.http.server.AsyncHttpServerRequestImpl;
import com.koushikdutta.async.http.server.AsyncHttpServerResponse;
import com.koushikdutta.async.http.server.AsyncHttpServerResponseImpl;
import com.koushikdutta.async.http.server.HttpServerRequestCallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AsyncHttpServer {
    ArrayList<AsyncServerSocket> mListeners = new ArrayList();
    ListenCallback mListenCallback = new ListenCallback(){

        @Override
        public void onAccepted(final AsyncSocket socket) {
            AsyncHttpServerRequestImpl req = new AsyncHttpServerRequestImpl(){
                Pair match;
                String fullPath;
                String path;
                boolean responseComplete;
                boolean requestComplete;
                AsyncHttpServerResponseImpl res;
                boolean hasContinued;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onHeadersReceived() {
                    RawHeaders headers = this.getRawHeaders();
                    if (!this.hasContinued && "100-continue".equals(headers.get("Expect"))) {
                        this.pause();
                        Util.writeAll((DataSink)this.mSocket, "HTTP/1.1 100 Continue\r\n".getBytes(), new CompletedCallback(){

                            @Override
                            public void onCompleted(Exception ex) {
                                this.resume();
                                if (ex != null) {
                                    this.report(ex);
                                    return;
                                }
                                hasContinued = true;
                                this.onHeadersReceived();
                            }
                        });
                        return;
                    }
                    String statusLine = headers.getStatusLine();
                    String[] parts = statusLine.split(" ");
                    this.fullPath = parts[1];
                    this.path = this.fullPath.split("\\?")[0];
                    String action = parts[0];
                    Hashtable<String, ArrayList<Pair>> hashtable = AsyncHttpServer.this.mActions;
                    synchronized (hashtable) {
                        ArrayList<Pair> pairs = AsyncHttpServer.this.mActions.get(action);
                        if (pairs != null) {
                            for (Pair p : pairs) {
                                Matcher m = p.regex.matcher(this.path);
                                if (!m.matches()) continue;
                                this.mMatcher = m;
                                this.match = p;
                                break;
                            }
                        }
                    }
                    this.res = new AsyncHttpServerResponseImpl(socket, this){

                        @Override
                        protected void onEnd() {
                            this.mSocket.setEndCallback(null);
                            responseComplete = true;
                            this.handleOnCompleted();
                        }
                    };
                    AsyncHttpServer.this.onRequest(this, this.res);
                    if (this.match == null) {
                        this.res.responseCode(404);
                        this.res.end();
                        return;
                    }
                    if (!this.getBody().readFullyOnRequest()) {
                        this.match.callback.onRequest(this, this.res);
                    } else if (this.requestComplete) {
                        this.match.callback.onRequest(this, this.res);
                    }
                }

                @Override
                public void onCompleted(Exception e) {
                    if (this.res.getHeaders().getHeaders().getResponseCode() == 101) {
                        return;
                    }
                    this.requestComplete = true;
                    super.onCompleted(e);
                    this.mSocket.setDataCallback(null);
                    this.mSocket.pause();
                    this.handleOnCompleted();
                    if (this.getBody().readFullyOnRequest()) {
                        this.match.callback.onRequest(this, this.res);
                    }
                }

                private void handleOnCompleted() {
                    if (this.requestComplete && this.responseComplete) {
                        this.onAccepted(socket);
                    }
                }

                @Override
                public String getPath() {
                    return this.path;
                }

                @Override
                public Multimap getQuery() {
                    String[] parts = this.fullPath.split("\\?", 2);
                    if (parts.length < 2) {
                        return new Multimap();
                    }
                    return Multimap.parseQuery(parts[1]);
                }
            };
            req.setSocket(socket);
            socket.resume();
        }

        @Override
        public void onCompleted(Exception error) {
            AsyncHttpServer.this.report(error);
        }

        @Override
        public void onListening(AsyncServerSocket socket) {
            AsyncHttpServer.this.mListeners.add(socket);
        }
    };
    CompletedCallback mCompletedCallback;
    Hashtable<String, ArrayList<Pair>> mActions = new Hashtable();
    static Hashtable<String, String> mContentTypes = new Hashtable();
    private static Hashtable<Integer, String> mCodes = new Hashtable();

    public AsyncHttpServer() {
        mContentTypes.put("js", "application/javascript");
        mContentTypes.put("json", "application/json");
        mContentTypes.put("png", "image/png");
        mContentTypes.put("jpg", "image/jpeg");
        mContentTypes.put("html", "text/html");
        mContentTypes.put("css", "text/css");
        mContentTypes.put("mp4", "video/mp4");
    }

    public void stop() {
        if (this.mListeners != null) {
            for (AsyncServerSocket listener : this.mListeners) {
                listener.stop();
            }
        }
    }

    protected void onRequest(AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
    }

    public void listen(AsyncServer server, int port) {
        server.listen(null, port, this.mListenCallback);
    }

    private void report(Exception ex) {
        if (this.mCompletedCallback != null) {
            this.mCompletedCallback.onCompleted(ex);
        }
    }

    public void listen(int port) {
        this.listen(AsyncServer.getDefault(), port);
    }

    public ListenCallback getListenCallback() {
        return this.mListenCallback;
    }

    public void setErrorCallback(CompletedCallback callback) {
        this.mCompletedCallback = callback;
    }

    public CompletedCallback getErrorCallback() {
        return this.mCompletedCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(String action, String regex, HttpServerRequestCallback callback) {
        Pair p = new Pair();
        p.regex = Pattern.compile("^" + regex);
        p.callback = callback;
        Hashtable<String, ArrayList<Pair>> hashtable = this.mActions;
        synchronized (hashtable) {
            ArrayList<Pair> pairs = this.mActions.get(action);
            if (pairs == null) {
                pairs = new ArrayList();
                this.mActions.put(action, pairs);
            }
            pairs.add(p);
        }
    }

    public void websocket(String regex, final WebSocketRequestCallback callback) {
        this.get(regex, new HttpServerRequestCallback(){

            @Override
            public void onRequest(AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
                boolean hasUpgrade = false;
                String connection = request.getHeaders().getHeaders().get("Connection");
                if (connection != null) {
                    String[] connections;
                    for (String c : connections = connection.split(",")) {
                        if (!"Upgrade".equalsIgnoreCase(c.trim())) continue;
                        hasUpgrade = true;
                        break;
                    }
                }
                if (!"websocket".equals(request.getHeaders().getHeaders().get("Upgrade")) || !hasUpgrade) {
                    response.responseCode(404);
                    response.end();
                    return;
                }
                callback.onConnected(new WebSocketImpl(request, response), request.getHeaders());
            }
        });
    }

    public void get(String regex, HttpServerRequestCallback callback) {
        this.addAction("GET", regex, callback);
    }

    public void post(String regex, HttpServerRequestCallback callback) {
        this.addAction("POST", regex, callback);
    }

    public static InputStream getAssetStream(Context context, String asset) {
        String apkPath = context.getPackageResourcePath();
        String assetPath = "assets/" + asset;
        try {
            ZipFile zip = new ZipFile(apkPath);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().equals(assetPath)) continue;
                return zip.getInputStream(entry);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return null;
    }

    public static String getContentType(String path) {
        String e;
        String ct;
        int index = path.lastIndexOf(".");
        if (index != -1 && (ct = mContentTypes.get(e = path.substring(index + 1))) != null) {
            return ct;
        }
        return "text/plain";
    }

    public void directory(Context _context, String regex, final String assetPath) {
        final Context context = _context.getApplicationContext();
        this.addAction("GET", regex, new HttpServerRequestCallback(){

            @Override
            public void onRequest(AsyncHttpServerRequest request, final AsyncHttpServerResponse response) {
                String path = request.getMatcher().replaceAll("");
                InputStream is = AsyncHttpServer.getAssetStream(context, assetPath + path);
                if (is == null) {
                    response.responseCode(404);
                    response.end();
                    return;
                }
                response.responseCode(200);
                response.getHeaders().getHeaders().add("Content-Type", AsyncHttpServer.getContentType(path));
                Util.pump(is, (DataSink)response, new CompletedCallback(){

                    @Override
                    public void onCompleted(Exception ex) {
                        response.end();
                    }
                });
            }
        });
    }

    public void directory(String regex, File directory) {
        this.directory(regex, directory, false);
    }

    public void directory(String regex, final File directory, final boolean list) {
        assert (directory.isDirectory());
        this.addAction("GET", regex, new HttpServerRequestCallback(){

            @Override
            public void onRequest(AsyncHttpServerRequest request, final AsyncHttpServerResponse response) {
                String path = request.getMatcher().replaceAll("");
                File file = new File(directory, path);
                if (file.isDirectory() && list) {
                    ArrayList<File> dirs = new ArrayList<File>();
                    ArrayList<File> files = new ArrayList<File>();
                    for (File f : file.listFiles()) {
                        if (f.isDirectory()) {
                            dirs.add(f);
                            continue;
                        }
                        files.add(f);
                    }
                    Comparator<File> c = new Comparator<File>(){

                        @Override
                        public int compare(File lhs, File rhs) {
                            return lhs.getName().compareTo(rhs.getName());
                        }
                    };
                    Collections.sort(dirs, c);
                    Collections.sort(files, c);
                    files.addAll(0, dirs);
                    return;
                }
                if (!file.isFile()) {
                    response.responseCode(404);
                    response.end();
                    return;
                }
                try {
                    FileInputStream is = new FileInputStream(file);
                    response.responseCode(200);
                    Util.pump(is, (DataSink)response, new CompletedCallback(){

                        @Override
                        public void onCompleted(Exception ex) {
                            response.end();
                        }
                    });
                }
                catch (Exception ex) {
                    response.responseCode(404);
                    response.end();
                    return;
                }
            }
        });
    }

    public static String getResponseCodeDescription(int code) {
        String d = mCodes.get(code);
        if (d == null) {
            return "Unknown";
        }
        return d;
    }

    static {
        mCodes.put(200, "OK");
        mCodes.put(101, "Switching Protocols");
        mCodes.put(404, "Not Found");
    }

    public static interface WebSocketRequestCallback {
        public void onConnected(WebSocket var1, RequestHeaders var2);
    }

    private static class Pair {
        Pattern regex;
        HttpServerRequestCallback callback;

        private Pair() {
        }
    }
}

