/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.stream;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.WritableCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class OutputStreamDataSink
implements DataSink {
    OutputStream mStream;
    WritableCallback mWritable;
    boolean closeReported;
    CompletedCallback mClosedCallback;

    public OutputStreamDataSink() {
    }

    @Override
    public void end() {
        this.close();
    }

    public OutputStreamDataSink(OutputStream stream) {
        this.setOutputStream(stream);
    }

    public void setOutputStream(OutputStream stream) {
        this.mStream = stream;
    }

    public OutputStream getOutputStream() {
        return this.mStream;
    }

    @Override
    public void write(ByteBuffer bb) {
        try {
            this.mStream.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        }
        catch (IOException e) {
            this.reportClose(e);
        }
        bb.position(0);
        bb.limit(0);
    }

    @Override
    public void write(ByteBufferList bb) {
        try {
            while (bb.size() > 0) {
                ByteBuffer b = bb.remove();
                this.mStream.write(b.array(), b.arrayOffset() + b.position(), b.remaining());
            }
        }
        catch (IOException e) {
            this.reportClose(e);
        }
        bb.clear();
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mWritable = handler;
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mWritable;
    }

    @Override
    public boolean isOpen() {
        return this.closeReported;
    }

    @Override
    public void close() {
        try {
            if (this.mStream != null) {
                this.mStream.close();
            }
            this.reportClose(null);
        }
        catch (IOException e) {
            this.reportClose(e);
        }
    }

    public void reportClose(Exception ex) {
        if (this.closeReported) {
            return;
        }
        this.closeReported = true;
        if (this.mClosedCallback != null) {
            this.mClosedCallback.onCompleted(ex);
        }
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mClosedCallback = handler;
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mClosedCallback;
    }

    @Override
    public AsyncServer getServer() {
        return AsyncServer.getDefault();
    }
}

