/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.nio.charset.StandardCharsets;
import kong.unirest.ContentType;

public abstract class BodyPart<T>
implements Comparable {
    private final String name;
    private final T value;
    private final String contentType;
    private final Class<?> partType;

    protected BodyPart(T value, String name, String contentType) {
        this.name = name;
        this.value = value;
        this.contentType = contentType;
        this.partType = value.getClass();
    }

    public T getValue() {
        return this.value;
    }

    public Class<?> getPartType() {
        return this.partType;
    }

    public String getContentType() {
        if (this.contentType == null) {
            if (this.isFile()) {
                return ContentType.APPLICATION_OCTET_STREAM.toString();
            }
            return ContentType.APPLICATION_FORM_URLENCODED.withCharset(StandardCharsets.UTF_8).toString();
        }
        return this.contentType;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public String getFileName() {
        return null;
    }

    public int compareTo(Object o) {
        if (o instanceof BodyPart) {
            return this.getName().compareTo(((BodyPart)o).getName());
        }
        return 0;
    }

    public abstract boolean isFile();
}

