/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.sql.split;

import com.klarna.hiverunner.sql.split.Consumer;
import com.klarna.hiverunner.sql.split.Context;
import com.klarna.hiverunner.sql.split.TokenRule;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public enum PreserveQuotesRule implements TokenRule
{
    INSTANCE;

    private static final Pattern LAST_CHAR_NOT_ESCAPED_PATTERN;

    @Override
    public Set<String> triggers() {
        return new HashSet<String>(Arrays.asList("\"", "'"));
    }

    @Override
    public void handle(String token, Context context) {
        context.appendWith(new QuotedStringConsumer(token));
    }

    static {
        LAST_CHAR_NOT_ESCAPED_PATTERN = Pattern.compile(".*[^\\\\].", 32);
    }

    static class QuotedStringConsumer
    implements Consumer {
        private final String token;

        QuotedStringConsumer(String token) {
            this.token = token;
        }

        @Override
        public String consume(Context context) {
            String quotedString = this.token;
            while (!(!context.tokenizer().hasMoreElements() || (quotedString = quotedString + (String)context.tokenizer().nextElement()).endsWith(this.token) && LAST_CHAR_NOT_ESCAPED_PATTERN.matcher(quotedString).matches())) {
            }
            return quotedString;
        }
    }
}

