/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.builder;

import com.google.common.base.Preconditions;
import com.klarna.hiverunner.HiveServerContainer;
import com.klarna.hiverunner.HiveShellContainer;
import com.klarna.hiverunner.builder.HiveResource;
import com.klarna.hiverunner.builder.HiveShellTearable;
import com.klarna.hiverunner.sql.cli.CommandShellEmulator;
import com.klarna.hiverunner.sql.cli.hive.HiveCliEmulator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HiveShellBuilder {
    private final List<String> scriptsUnderTest = new ArrayList<String>();
    private final Map<String, String> props = new HashMap<String, String>();
    private HiveServerContainer hiveServerContainer;
    private final List<HiveResource> resources = new ArrayList<HiveResource>();
    private final List<String> setupScripts = new ArrayList<String>();
    private CommandShellEmulator commandShellEmulator = HiveCliEmulator.INSTANCE;

    public void setHiveServerContainer(HiveServerContainer hiveServerContainer) {
        this.hiveServerContainer = hiveServerContainer;
    }

    public void putAllProperties(Map<String, String> props) {
        this.props.putAll(props);
    }

    public void addSetupScript(String script) {
        this.setupScripts.add(script);
    }

    public void addResource(String targetFile, Path dataFile) throws IOException {
        this.resources.add(new HiveResource(targetFile, dataFile));
    }

    public void addResource(String targetFile, String data) throws IOException {
        this.resources.add(new HiveResource(targetFile, data));
    }

    public void setScriptsUnderTest(List<Path> scripts, Charset charset) {
        for (Path script : scripts) {
            Preconditions.checkState((boolean)Files.exists(script, new LinkOption[0]), (String)"File %s does not exist", (Object[])new Object[]{script});
            try {
                this.scriptsUnderTest.add(new String(Files.readAllBytes(script), charset));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to load script file '" + script + "'");
            }
        }
    }

    public void setCommandShellEmulation(CommandShellEmulator commandShellEmulator) {
        this.commandShellEmulator = commandShellEmulator;
    }

    public HiveShellContainer buildShell() {
        return new HiveShellTearable(this.hiveServerContainer, this.props, this.setupScripts, this.resources, this.scriptsUnderTest, this.commandShellEmulator);
    }
}

