/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner;

import com.klarna.hiverunner.HiveServerContext;
import com.klarna.hiverunner.config.HiveRunnerConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneHiveServerContext
implements HiveServerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneHiveServerContext.class);
    private String metaStorageUrl;
    protected HiveConf hiveConf = new HiveConf();
    private final TemporaryFolder basedir;
    private final HiveRunnerConfig hiveRunnerConfig;

    public StandaloneHiveServerContext(TemporaryFolder basedir, HiveRunnerConfig hiveRunnerConfig) {
        this.basedir = basedir;
        this.hiveRunnerConfig = hiveRunnerConfig;
    }

    @Override
    public final void init() {
        this.configureMiscHiveSettings(this.hiveConf);
        this.configureMetaStore(this.hiveConf);
        this.configureMrExecutionEngine(this.hiveConf);
        this.configureTezExecutionEngine(this.hiveConf);
        this.configureJavaSecurityRealm(this.hiveConf);
        this.configureSupportConcurrency(this.hiveConf);
        this.configureFileSystem(this.basedir, this.hiveConf);
        this.configureAssertionStatus(this.hiveConf);
        this.overrideHiveConf(this.hiveConf);
    }

    protected void configureMiscHiveSettings(HiveConf hiveConf) {
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER, false);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_CBO_ENABLED, false);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED, false);
        hiveConf.setVar(HiveConf.ConfVars.HADOOPBIN, "NO_BIN!");
    }

    protected void overrideHiveConf(HiveConf hiveConf) {
        for (Map.Entry<String, String> hiveConfEntry : this.hiveRunnerConfig.getHiveConfSystemOverride().entrySet()) {
            hiveConf.set(hiveConfEntry.getKey(), hiveConfEntry.getValue());
        }
    }

    protected void configureMrExecutionEngine(HiveConf conf) {
        conf.setBoolVar(HiveConf.ConfVars.HIVE_INFER_BUCKET_SORT, false);
        conf.setBoolVar(HiveConf.ConfVars.HIVEMETADATAONLYQUERIES, false);
        conf.setBoolVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER, false);
        conf.setBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN, false);
        conf.setBoolVar(HiveConf.ConfVars.HIVESKEWJOIN, false);
        this.hiveConf.setLongVar(HiveConf.ConfVars.HIVECOUNTERSPULLINTERVAL, 1L);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_RPC_QUERY_PLAN, true);
    }

    protected void configureTezExecutionEngine(HiveConf conf) {
        conf.setBoolean("tez.local.mode", true);
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.runtime.optimize.local.fetch", true);
        conf.set("tez.am.disable.client-version-check", "true");
        conf.set("tez.am.use.concurrent-dispatcher", "false");
        conf.set("tez.am.container.reuse.enabled", "false");
        conf.set("tez.dag.recovery.enabled", "false");
        conf.set("tez.task.get-task.sleep.interval-ms.max", "1");
        conf.set("tez.am.tez-ui.webservice.enable", "false");
        conf.set("tez.dag.recovery.enabled", "false");
        conf.set("tez.am.node-blacklisting.enabled", "false");
    }

    protected void configureJavaSecurityRealm(HiveConf hiveConf) {
        System.setProperty("java.security.krb5.realm", "");
        System.setProperty("java.security.krb5.kdc", "");
        System.setProperty("java.security.krb5.conf", "/dev/null");
    }

    protected void configureAssertionStatus(HiveConf conf) {
        ClassLoader.getSystemClassLoader().setPackageAssertionStatus("org.apache.hadoop.hive.serde2.objectinspector", false);
    }

    protected void configureSupportConcurrency(HiveConf conf) {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
    }

    protected void configureMetaStore(HiveConf conf) {
        this.configureDerbyLog();
        String jdbcDriver = EmbeddedDriver.class.getName();
        try {
            Class.forName(jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.metaStorageUrl = "jdbc:derby:memory:" + UUID.randomUUID().toString();
        this.hiveConf.set("datanucleus.schema.autoCreateAll", "true");
        this.hiveConf.set("hive.metastore.schema.verification", "false");
        this.hiveConf.set("datanucleus.connectiondrivername", jdbcDriver);
        this.hiveConf.set("javax.jdo.option.ConnectionDriverName", jdbcDriver);
        this.hiveConf.set("datanucleus.connectionPoolingType", "None");
        conf.setBoolVar(HiveConf.ConfVars.METASTORE_VALIDATE_CONSTRAINTS, true);
        conf.setBoolVar(HiveConf.ConfVars.METASTORE_VALIDATE_COLUMNS, true);
        conf.setBoolVar(HiveConf.ConfVars.METASTORE_VALIDATE_TABLES, true);
    }

    private void configureDerbyLog() {
        File derbyLogFile;
        try {
            derbyLogFile = File.createTempFile("derby", ".log");
            LOGGER.debug("Derby set to log to " + derbyLogFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating temporary derby log file", e);
        }
        System.setProperty("derby.stream.error.file", derbyLogFile.getAbsolutePath());
    }

    protected void configureFileSystem(TemporaryFolder basedir, HiveConf conf) {
        conf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, this.metaStorageUrl + ";create=true");
        this.createAndSetFolderProperty(HiveConf.ConfVars.METASTOREWAREHOUSE, "warehouse", conf, basedir);
        this.createAndSetFolderProperty(HiveConf.ConfVars.SCRATCHDIR, "scratchdir", conf, basedir);
        this.createAndSetFolderProperty(HiveConf.ConfVars.LOCALSCRATCHDIR, "localscratchdir", conf, basedir);
        this.createAndSetFolderProperty(HiveConf.ConfVars.HIVEHISTORYFILELOC, "tmp", conf, basedir);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS, true);
        this.createAndSetFolderProperty("hadoop.tmp.dir", "hadooptmp", conf, basedir);
        this.createAndSetFolderProperty("test.log.dir", "logs", conf, basedir);
        File installation_dir = this.newFolder(this.getBaseDir(), "tez_installation_dir");
        conf.setVar(HiveConf.ConfVars.HIVE_JAR_DIRECTORY, installation_dir.getAbsolutePath());
        conf.setVar(HiveConf.ConfVars.HIVE_USER_INSTALL_DIR, installation_dir.getAbsolutePath());
    }

    File newFolder(TemporaryFolder basedir, String folder) {
        try {
            File newFolder = basedir.newFolder(folder);
            FileUtil.setPermission((File)newFolder, (FsPermission)FsPermission.getDirDefault());
            return newFolder;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create tmp dir: " + e.getMessage(), e);
        }
    }

    @Override
    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    @Override
    public TemporaryFolder getBaseDir() {
        return this.basedir;
    }

    protected final void createAndSetFolderProperty(HiveConf.ConfVars var, String folder, HiveConf conf, TemporaryFolder basedir) {
        conf.setVar(var, this.newFolder(basedir, folder).getAbsolutePath());
    }

    protected final void createAndSetFolderProperty(String key, String folder, HiveConf conf, TemporaryFolder basedir) {
        conf.set(key, this.newFolder(basedir, folder).getAbsolutePath());
    }
}

