/*
 * Decompiled with CFR 0.152.
 */
package com.khubla.antlr4formatter.listener;

import com.khubla.antlr4formatter.listener.FormatterListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatterParseTreeListenerImpl
implements ParseTreeListener {
    private static final Logger logger = LoggerFactory.getLogger(FormatterParseTreeListenerImpl.class);
    private static final Set<String> commentTokens = new HashSet<String>(Arrays.asList("/*", "//"));
    private final FormatterListener formatterListener;
    private int commentTokenPos = -1;
    private final CommonTokenStream commonTokenStream;

    public FormatterParseTreeListenerImpl(FormatterListener formatterListener, CommonTokenStream commonTokenStream) {
        this.formatterListener = formatterListener;
        this.commonTokenStream = commonTokenStream;
    }

    public void enterEveryRule(ParserRuleContext ctx) {
        logger.debug("Enter rule: " + ctx.getText());
        this.formatterListener.enterEveryRule(ctx);
    }

    public void exitEveryRule(ParserRuleContext ctx) {
        logger.debug("Exit rule: " + ctx.getText());
        this.formatterListener.exitEveryRule(ctx);
    }

    private FormatterListener.CommentType getCommentType(String comment) {
        if (comment.startsWith("//")) {
            return FormatterListener.CommentType.line;
        }
        return FormatterListener.CommentType.block;
    }

    private void handleLeftCommentTokens(TerminalNode node) {
        int tokPos = node.getSymbol().getTokenIndex();
        if (tokPos > this.commentTokenPos) {
            List leftCommentTokens = this.commonTokenStream.getHiddenTokensToLeft(tokPos, 3);
            if (null != leftCommentTokens && leftCommentTokens.size() > 0) {
                for (Token commentToken : leftCommentTokens) {
                    if (commentToken.getTokenIndex() > this.commentTokenPos) {
                        String str;
                        List skippedTokens = this.commonTokenStream.getHiddenTokensToLeft(commentToken.getTokenIndex(), 2);
                        int lfCount = 0;
                        if (null != skippedTokens) {
                            for (Token skippedToken : skippedTokens) {
                                if (skippedToken.getText().indexOf("\n") == -1) continue;
                                ++lfCount;
                            }
                        }
                        if ((str = commentToken.getText().trim()).length() > 0 && this.isComment(str)) {
                            this.formatterListener.visitComment(commentToken, true, this.getCommentType(commentToken.getText()), lfCount > 0);
                        }
                    }
                    if (commentToken.getTokenIndex() <= this.commentTokenPos) continue;
                    this.commentTokenPos = commentToken.getTokenIndex();
                }
            } else {
                this.commentTokenPos = tokPos;
            }
        }
    }

    private void handleRightCommentTokens(TerminalNode node) {
        int tokPos = node.getSymbol().getTokenIndex();
        if (tokPos >= this.commentTokenPos) {
            List rightCommentTokens = this.commonTokenStream.getHiddenTokensToRight(tokPos, 3);
            if (null != rightCommentTokens && rightCommentTokens.size() > 0) {
                for (Token commentToken : rightCommentTokens) {
                    String str;
                    List skippedTokens = this.commonTokenStream.getHiddenTokensToLeft(commentToken.getTokenIndex(), 2);
                    int lfCount = 0;
                    if (null != skippedTokens) {
                        for (Token skippedToken : skippedTokens) {
                            if (skippedToken.getText().indexOf("\n") == -1) continue;
                            ++lfCount;
                        }
                    }
                    if ((str = commentToken.getText().trim()).length() > 0 && this.isComment(str)) {
                        this.formatterListener.visitComment(commentToken, false, this.getCommentType(commentToken.getText()), lfCount > 0);
                    }
                    if (commentToken.getTokenIndex() <= this.commentTokenPos) continue;
                    this.commentTokenPos = commentToken.getTokenIndex();
                }
            } else {
                this.commentTokenPos = tokPos;
            }
        }
    }

    private boolean isComment(String str) {
        for (String c : commentTokens) {
            if (!str.startsWith(c)) continue;
            return true;
        }
        return false;
    }

    protected int tokenStart(ParserRuleContext ctx) {
        return ctx.getStart().getTokenIndex() < ctx.getStop().getTokenIndex() ? ctx.getStart().getTokenIndex() : ctx.getStop().getTokenIndex();
    }

    protected int tokenStop(ParserRuleContext ctx) {
        return ctx.getStop().getTokenIndex() > ctx.getStart().getTokenIndex() ? ctx.getStop().getTokenIndex() : ctx.getStart().getTokenIndex();
    }

    public void visitErrorNode(ErrorNode node) {
        logger.debug("Error: " + node.getText());
        this.formatterListener.visitErrorNode(node);
    }

    public void visitTerminal(TerminalNode node) {
        logger.debug("Terminal: " + node.getText());
        this.handleLeftCommentTokens(node);
        this.formatterListener.visitTerminal(node);
        this.handleRightCommentTokens(node);
    }
}

