/*
 * Decompiled with CFR 0.152.
 */
package com.khubla.antlr4formatter;

import com.khubla.antlr4formatter.listener.FormatterListener;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.antlr.parser.antlr4.ANTLRv4Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Antlr4FormatterListenerImpl
implements FormatterListener {
    private static final Logger logger = LoggerFactory.getLogger(Antlr4FormatterListenerImpl.class);
    private static final Set<String> noSpacingBeforeTokens = new HashSet<String>(Arrays.asList("?", "*", ";", ")", "+"));
    private static final Set<String> noSpacingAfterTokens = new HashSet<String>(Arrays.asList("("));
    private static final Set<Class<?>> newlineAfterRules = new HashSet<Class>(Arrays.asList(ANTLRv4Parser.GrammarDeclContext.class, ANTLRv4Parser.ParserRuleSpecContext.class, ANTLRv4Parser.LexerRuleSpecContext.class));
    private static final Set<Class<?>> colonOnNewlineRules = new HashSet<Class>(Arrays.asList(ANTLRv4Parser.ParserRuleSpecContext.class, ANTLRv4Parser.LexerRuleSpecContext.class));
    private static final Set<Class<?>> newlineBeforeRules = new HashSet<Class>(Arrays.asList(ANTLRv4Parser.PrequelConstructContext.class, ANTLRv4Parser.GrammarDeclContext.class, ANTLRv4Parser.ParserRuleSpecContext.class, ANTLRv4Parser.LexerRuleSpecContext.class, ANTLRv4Parser.OptionsSpecContext.class, ANTLRv4Parser.ModeSpecContext.class, ANTLRv4Parser.ActionBlockContext.class));
    private static final Set<Class<?>> indentedeRules = new HashSet<Class>(Arrays.asList(ANTLRv4Parser.ParserRuleSpecContext.class, ANTLRv4Parser.LexerRuleSpecContext.class));
    private static final Set<String> newlineBeforeTokens = new HashSet<String>(Arrays.asList(":", "|"));
    private static final Set<Class<?>> interpretAsLiteralRules = new HashSet<Class>(Arrays.asList(ANTLRv4Parser.ArgActionBlockContext.class, ANTLRv4Parser.ActionBlockContext.class));
    private static final int DEFAULT_INDENT_SIZE = 3;
    private static final IndentType DEFAULT_INDENT_TYPE = IndentType.space;
    private static final boolean DEBUG = false;
    private int indent = 0;
    private boolean newline = true;
    private final Writer writer;
    private String previousToken = "";
    private int indentSize;
    private IndentType indentType;
    private int parenthCount = 0;
    private boolean outputStarted = false;

    public Antlr4FormatterListenerImpl(Writer writer) {
        this.writer = writer;
        this.indentSize = 3;
        this.indentType = DEFAULT_INDENT_TYPE;
    }

    private String buildIndent(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent * this.indentSize; ++i) {
            if (this.indentType == IndentType.space) {
                sb.append(" ");
                continue;
            }
            sb.append("/t");
        }
        return sb.toString();
    }

    public void enterEveryRule(ParserRuleContext ctx) {
        logger.debug("enter rule: " + ctx.getClass().getSimpleName());
        if (newlineBeforeRules.contains(ctx.getClass())) {
            this.writeCR();
        }
        if (indentedeRules.contains(ctx.getClass())) {
            ++this.indent;
        }
    }

    public void exitEveryRule(ParserRuleContext ctx) {
        logger.debug("exit rule: " + ctx.getClass().getSimpleName());
        if (indentedeRules.contains(ctx.getClass())) {
            --this.indent;
        }
        if (newlineAfterRules.contains(ctx.getClass()) && !this.newline) {
            this.writeCR();
        }
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public IndentType getIndentType() {
        return this.indentType;
    }

    protected boolean isInParenth() {
        return this.parenthCount != 0;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    public void setIndentType(IndentType indentType) {
        this.indentType = indentType;
    }

    @Override
    public void visitComment(Token token, boolean left, FormatterListener.CommentType commentType, boolean nl) {
        if (!this.newline && !nl) {
            this.write(" ");
        }
        if (nl) {
            if (commentType == FormatterListener.CommentType.line) {
                this.writeCR();
            } else {
                this.writeSimple("\n");
            }
        }
        this.writeSimple(token.getText());
        if (commentType == FormatterListener.CommentType.block || left) {
            this.writeCR();
        }
        if (commentType == FormatterListener.CommentType.line || !left) {
            this.writeCR();
        }
    }

    public void visitErrorNode(ErrorNode node) {
        System.out.println("Error: " + node.getText());
    }

    public void visitTerminal(TerminalNode node) {
        if (node.getSymbol().getType() != -1) {
            if (!interpretAsLiteralRules.contains(node.getParent().getClass())) {
                if (node.toString().compareTo("(") == 0) {
                    ++this.parenthCount;
                } else if (node.toString().compareTo(")") == 0) {
                    --this.parenthCount;
                }
            }
            if (newlineBeforeTokens.contains(node.toString()) && !this.newline && !interpretAsLiteralRules.contains(node.getParent().getClass()) && !this.isInParenth()) {
                this.writeCR();
            }
            if (node.toString().compareTo(";") == 0 && colonOnNewlineRules.contains(node.getParent().getClass())) {
                this.writeCR();
            }
            this.write(node);
        } else {
            this.writeCR();
        }
    }

    protected void write(String str) {
        this.writeSimple(str);
        if (this.newline) {
            this.newline = false;
        }
        this.previousToken = str;
    }

    private void write(TerminalNode node) {
        logger.debug("Writing: '" + node.getText() + "'");
        if (!(this.newline || noSpacingAfterTokens.contains(this.previousToken) || noSpacingBeforeTokens.contains(node.getText()) || interpretAsLiteralRules.contains(node.getParent().getClass()))) {
            this.writeSimple(" ");
        }
        this.writeSimple(node.getText());
        if (this.newline) {
            this.newline = false;
        }
        this.previousToken = node.getText();
    }

    private void writeCR() {
        if (this.outputStarted) {
            this.writeSimple("\n");
            this.writeSimple(this.buildIndent(this.indent));
            this.newline = true;
        }
    }

    private void writeSimple(String string) {
        try {
            this.writer.write(string);
            if (string.trim().length() > 0 && !this.outputStarted) {
                this.outputStarted = true;
            }
        }
        catch (IOException e) {
            logger.error("Could not write to writer", (Throwable)e);
        }
    }

    public static enum IndentType {
        tab,
        space;

    }
}

