/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.hickory.testing;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class MemSourceFileObject
extends SimpleJavaFileObject {
    private StringBuilder contents = new StringBuilder(1000);

    MemSourceFileObject(String fqname) {
        super(MemSourceFileObject.toUri(fqname), JavaFileObject.Kind.SOURCE);
    }

    private static URI toUri(String fqname) {
        return URI.create(fqname.replace(".", "/") + ".java");
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.contents;
    }

    public MemSourceFileObject addLine(String line) {
        this.contents.append(line).append('\n');
        return this;
    }

    @Override
    public Writer openWriter() {
        return new Writer(){

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            @Override
            public Writer append(CharSequence csq) throws IOException {
                MemSourceFileObject.this.contents.append(csq);
                return this;
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                MemSourceFileObject.this.contents.append(cbuf, off, len);
            }
        };
    }
}

