/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.manifests;

import com.jcabi.log.Logger;
import com.jcabi.manifests.ClasspathMfs;
import com.jcabi.manifests.MfMap;
import com.jcabi.manifests.Mfs;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class Manifests
implements MfMap {
    private static final AtomicReference<MfMap> DEFAULT = new AtomicReference<Manifests>(new Manifests());
    private final transient Map<String, String> attributes;

    public Manifests() {
        this(new HashMap<String, String>(0));
    }

    public Manifests(Map<String, String> attrs) {
        this.attributes = new ConcurrentHashMap<String, String>(attrs);
    }

    public static MfMap singleton() {
        return DEFAULT.get();
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public boolean containsValue(String value) {
        return this.attributes.containsValue(value);
    }

    @Override
    public String get(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Map<String, String> getAsMap() {
        return new HashMap<String, String>(this.attributes);
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.attributes.keySet());
    }

    @Override
    public void append(Mfs mfs) throws IOException {
        long start = System.currentTimeMillis();
        Collection<InputStream> list = mfs.fetch();
        int saved = 0;
        int ignored = 0;
        for (InputStream stream : list) {
            for (Map.Entry<String, String> attr : Manifests.load(stream).entrySet()) {
                if (this.attributes.containsKey(attr.getKey())) {
                    ++ignored;
                    continue;
                }
                this.attributes.put(attr.getKey(), attr.getValue());
                ++saved;
            }
        }
        Logger.info((Object)this, (String)"%d attributes loaded from %d stream(s) in %[ms]s, %d saved, %d ignored: %[list]s", (Object[])new Object[]{this.attributes.size(), list.size(), System.currentTimeMillis() - start, saved, ignored, new TreeSet<String>(this.attributes.keySet())});
    }

    public static String read(String name) {
        if (name == null) {
            throw new IllegalArgumentException("attribute can't be NULL");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("attribute can't be empty");
        }
        if (!Manifests.exists(name)) {
            throw new IllegalArgumentException(Logger.format((String)"Attribute '%s' not found in MANIFEST.MF file(s) among %d other attribute(s): %[list]s", (Object[])new Object[]{name, Manifests.singleton().size(), new TreeSet<String>(Manifests.singleton().keySet())}));
        }
        return Manifests.singleton().get(name);
    }

    public static boolean exists(String name) {
        if (name == null) {
            throw new IllegalArgumentException("attribute name can't be NULL");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("attribute name can't be empty");
        }
        return Manifests.singleton().containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> load(InputStream stream) throws IOException {
        ConcurrentHashMap<String, String> props = new ConcurrentHashMap<String, String>(0);
        try {
            Manifest manifest = new Manifest(stream);
            Attributes attrs = manifest.getMainAttributes();
            for (Object key : attrs.keySet()) {
                String value = attrs.getValue((Attributes.Name)Attributes.Name.class.cast(key));
                props.put(key.toString(), value);
            }
            Logger.debug(Manifests.class, (String)"%d attribute(s) loaded %[list]s", (Object[])new Object[]{props.size(), new TreeSet(props.keySet())});
        }
        catch (RuntimeException ex) {
            Manifests.logLoadFailedError(ex);
        }
        finally {
            stream.close();
        }
        return props;
    }

    private static void logLoadFailedError(Exception exn) {
        Logger.error(Manifests.class, (String)"#load(): failed %[exception]s", (Object[])new Object[]{exn});
    }

    static {
        try {
            Manifests.singleton().append(new ClasspathMfs());
        }
        catch (IOException ex) {
            Manifests.logLoadFailedError(ex);
        }
    }
}

