/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import java.util.Formattable;
import java.util.Formatter;

final class NanoDecor
implements Formattable {
    private final transient Double nano;

    NanoDecor(Long nan) {
        this.nano = nan == null ? null : Double.valueOf(nan.longValue());
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.nano == null) {
            formatter.format("NULL", new Object[0]);
        } else {
            StringBuilder format = new StringBuilder(0);
            format.append('%');
            if ((flags & 1) == 1) {
                format.append('-');
            }
            if (width > 0) {
                format.append(width);
            }
            if ((flags & 2) == 2) {
                format.append('S');
            } else {
                format.append('s');
            }
            formatter.format(format.toString(), this.toText(precision));
        }
    }

    private String toText(int precision) {
        String title;
        double number;
        if (this.nano < 1000.0) {
            number = this.nano;
            title = "ns";
        } else if (this.nano < 1000000.0) {
            number = this.nano / 1000.0;
            title = "\u00b5s";
        } else if (this.nano < 1.0E9) {
            number = this.nano / 1000000.0;
            title = "ms";
        } else if (this.nano < 6.0E10) {
            number = this.nano / 1.0E9;
            title = "s";
        } else {
            number = this.nano / 6.0E10;
            title = "min";
        }
        String format = precision >= 0 ? String.format("%%.%df%%s", precision) : "%.0f%s";
        return String.format(format, number, title);
    }
}

