/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.ColorfullyFormatted;
import com.jcabi.log.Colors;
import com.jcabi.log.ConversionPattern;
import com.jcabi.log.DullyFormatted;
import com.jcabi.log.Formatted;
import com.jcabi.log.ParseableInformation;
import com.jcabi.log.ParseableLevelInformation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public final class MulticolorLayout
extends EnhancedPatternLayout {
    private static final String COLORING_PROPERY = "com.jcabi.log.coloring";
    private final transient ConcurrentMap<String, String> levels = MulticolorLayout.levelMap();
    private transient String base;
    private final transient Colors colors = new Colors();

    public void setConversionPattern(String pattern) {
        this.base = pattern;
        super.setConversionPattern(new ConversionPattern(this.base, this.colors).generate());
    }

    public void setColors(String cols) {
        Map<String, String> parsed = new ParseableInformation(cols).information();
        for (Map.Entry<String, String> entry : parsed.entrySet()) {
            this.colors.addColor(entry.getKey(), entry.getValue());
        }
        if (this.base != null) {
            this.setConversionPattern(this.base);
        }
    }

    public void setLevels(String lev) {
        Map<String, String> parsed = new ParseableLevelInformation(lev).information();
        for (Map.Entry<String, String> entry : parsed.entrySet()) {
            this.levels.put(entry.getKey(), entry.getValue());
        }
    }

    public String format(LoggingEvent event) {
        Formatted formatted = MulticolorLayout.isColoringEnabled() ? this.colorfulFormatting(event) : this.dullFormatting(event);
        return formatted.format();
    }

    private Formatted dullFormatting(LoggingEvent event) {
        return new DullyFormatted(super.format(event));
    }

    private Formatted colorfulFormatting(LoggingEvent event) {
        return new ColorfullyFormatted(super.format(event), (String)this.levels.get(event.getLevel().toString()));
    }

    private static ConcurrentMap<String, String> levelMap() {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>(0);
        map.put(Level.TRACE.toString(), "2;33");
        map.put(Level.DEBUG.toString(), "2;37");
        map.put(Level.INFO.toString(), "0;37");
        map.put(Level.WARN.toString(), "0;33");
        map.put(Level.ERROR.toString(), "0;31");
        map.put(Level.FATAL.toString(), "0;35");
        return map;
    }

    private static boolean isColoringEnabled() {
        return !"false".equals(System.getProperty(COLORING_PROPERY));
    }
}

