/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.log.Logger;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;

@Immutable
public final class RetryWire
implements Wire {
    private final transient Wire origin;

    public RetryWire(Wire wire) {
        this.origin = wire;
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> hdrs, InputStream cont, int conn, int read) throws IOException {
        int attempt = 0;
        while (true) {
            if (attempt > 3) {
                throw new IOException(String.format("failed after %d attempts", attempt));
            }
            try {
                Response rsp = this.sendRequest(req, home, method, hdrs, cont, conn, read);
                if (rsp.status() < 500) {
                    return rsp;
                }
                this.logWarning(method, home, rsp.status(), attempt);
            }
            catch (IOException ex) {
                this.logWarning(ex);
            }
            ++attempt;
        }
    }

    private Response sendRequest(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        return this.origin.send(req, home, method, headers, content, connect, read);
    }

    private void logWarning(String method, String home, int status, int attempt) {
        if (Logger.isWarnEnabled((Object)this)) {
            URI uri = URI.create(home);
            String noauth = UriBuilder.fromUri((URI)uri).userInfo("").toString();
            String authinfo = "";
            if (uri.getUserInfo() != null) {
                authinfo = Logger.format((String)" (auth: %[secret]s)", (Object[])new Object[]{uri.getUserInfo()});
            }
            Logger.warn((Object)this, (String)"%s %s%s returns %d status (attempt #%d)", (Object[])new Object[]{method, noauth, authinfo, status, attempt + 1});
        }
    }

    private void logWarning(IOException exp) {
        if (Logger.isWarnEnabled((Object)this)) {
            Logger.warn((Object)this, (String)"%s: %s", (Object[])new Object[]{exp.getClass().getName(), exp.getLocalizedMessage()});
        }
    }

    @Generated
    public String toString() {
        return "RetryWire(origin=" + this.origin + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetryWire)) {
            return false;
        }
        RetryWire other = (RetryWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

