/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;

@Immutable
public final class CookieOptimizingWire
implements Wire {
    private final transient Wire origin;

    public CookieOptimizingWire(Wire wire) {
        this.origin = wire;
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        LinkedList<Map.Entry<String, String>> hdrs = new LinkedList<Map.Entry<String, String>>();
        ConcurrentHashMap cookies = new ConcurrentHashMap(0);
        headers.forEach(header -> {
            if (((String)header.getKey()).equals("Cookie")) {
                String cookie = (String)header.getValue();
                int split = cookie.indexOf(61);
                String name = cookie.substring(0, split);
                String value = cookie.substring(split + 1);
                if (value.isEmpty()) {
                    cookies.remove(name);
                } else {
                    cookies.put(name, value);
                }
            } else {
                hdrs.add((Map.Entry<String, String>)header);
            }
        });
        if (!cookies.isEmpty()) {
            String text = cookies.entrySet().stream().filter(cookie -> !((String)cookie.getValue()).isEmpty()).map(cookie -> (String)cookie.getKey() + '=' + (String)cookie.getValue()).collect(Collectors.joining("; "));
            hdrs.add(new ImmutableHeader("Cookie", text));
        }
        return this.origin.send(req, home, method, hdrs, content, connect, read);
    }

    @Generated
    public String toString() {
        return "CookieOptimizingWire(origin=" + this.origin + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CookieOptimizingWire)) {
            return false;
        }
        CookieOptimizingWire other = (CookieOptimizingWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

