/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.response;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.response.AbstractResponse;
import com.jcabi.http.response.RestResponse;
import com.jcabi.immutable.ArrayMap;
import com.jcabi.matchers.XhtmlMatchers;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import com.jcabi.xml.XPathContext;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import lombok.Generated;

@Immutable
public final class XmlResponse
extends AbstractResponse {
    private final transient ArrayMap<String, String> namespaces;

    public XmlResponse(Response resp) {
        this(resp, (ArrayMap<String, String>)new ArrayMap());
    }

    private XmlResponse(Response resp, ArrayMap<String, String> map) {
        super(resp);
        this.namespaces = map;
    }

    public XML xml() {
        return new XMLDocument(this.body()).merge(this.context());
    }

    public XmlResponse registerNs(String prefix, String uri) {
        return new XmlResponse(this, (ArrayMap<String, String>)this.namespaces.with((Object)prefix, (Object)uri));
    }

    public XmlResponse assertXPath(String xpath) {
        String body = this.body();
        if (!XhtmlMatchers.hasXPath((String)xpath, (NamespaceContext)this.context()).matches((Object)body)) {
            throw new AssertionError((Object)String.format("XML doesn't contain required XPath '%s':%n%s", xpath, body));
        }
        return this;
    }

    public Request rel(String query) {
        this.assertXPath(query);
        return new RestResponse(this).jump(URI.create((String)this.xml().xpath(query).get(0)));
    }

    private NamespaceContext context() {
        XPathContext context = new XPathContext();
        for (Map.Entry entry : this.namespaces.entrySet()) {
            context = context.add((String)entry.getKey(), entry.getValue());
        }
        return context;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XmlResponse)) {
            return false;
        }
        XmlResponse other = (XmlResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof XmlResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

