/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.mock;

import com.jcabi.http.mock.GrizzlyQuery;
import com.jcabi.http.mock.MkAnswer;
import com.jcabi.http.mock.MkQuery;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.hamcrest.Matcher;

final class MkGrizzlyAdapter
extends HttpHandler {
    private static final String ENCODING = "UTF-8";
    private final transient Queue<QueryWithAnswer> queue = new ConcurrentLinkedQueue<QueryWithAnswer>();
    private final transient Queue<Conditional> conditionals = new ConcurrentLinkedQueue<Conditional>();

    MkGrizzlyAdapter() {
    }

    public void service(Request request, Response response) {
        try {
            this.handleRequest(request, response);
        }
        catch (IOException ex) {
            MkGrizzlyAdapter.fail(response, ex);
        }
    }

    public void next(MkAnswer answer, Matcher<MkQuery> query, int count) {
        this.conditionals.add(new Conditional(answer, query, count));
    }

    public MkQuery take() {
        return this.queue.remove().que;
    }

    public MkQuery take(Matcher<MkAnswer> matcher) {
        return this.takeMatching(matcher).next();
    }

    public Collection<MkQuery> takeAll(Matcher<MkAnswer> matcher) {
        LinkedList<MkQuery> results = new LinkedList<MkQuery>();
        Iterator<MkQuery> iter = this.takeMatching(matcher);
        while (iter.hasNext()) {
            results.add(iter.next());
        }
        return results;
    }

    public int queries() {
        return this.queue.size();
    }

    private Iterator<MkQuery> takeMatching(Matcher<MkAnswer> matcher) {
        Iterator<QueryWithAnswer> iter = this.queue.iterator();
        MkQueryIterator result = new MkQueryIterator(iter, matcher);
        if (!result.hasNext()) {
            throw new NoSuchElementException("No matching results found");
        }
        return result;
    }

    private static void fail(Response response, Throwable failure) {
        response.setStatus(500);
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)response.createOutputStream(), ENCODING));){
            writer.print(Logger.format((String)"%[exception]s", (Object[])new Object[]{failure}));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void handleRequest(Request request, Response response) throws IOException {
        GrizzlyQuery query = new GrizzlyQuery(request);
        boolean matched = this.processConditionals(query, response);
        if (!matched) {
            throw new NoSuchElementException("No matching answers found.");
        }
    }

    private boolean processConditionals(MkQuery query, Response response) {
        Iterator iter = this.conditionals.iterator();
        boolean res = false;
        while (iter.hasNext()) {
            Conditional cond = (Conditional)iter.next();
            if (!cond.matches(query)) continue;
            this.handleMatchingConditional(cond, query, response);
            if (cond.decrement() == 0) {
                iter.remove();
            }
            res = true;
            break;
        }
        return res;
    }

    private void handleMatchingConditional(Conditional cond, MkQuery query, Response response) {
        MkAnswer answer = cond.answer();
        this.queue.add(new QueryWithAnswer(query, answer));
        MkGrizzlyAdapter.addHeadersToResponse(answer.headers(), response);
        this.addServerHeader(response);
        MkGrizzlyAdapter.setResponseStatusAndBody(response, answer);
    }

    private static void addHeadersToResponse(Map<String, List<String>> headers, Response response) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            for (String value : entry.getValue()) {
                response.addHeader(entry.getKey(), value);
            }
        }
    }

    private void addServerHeader(Response response) {
        response.addHeader("Server", String.format("%s query #%d, %d answer(s) left", ((Object)((Object)this)).getClass().getName(), this.queue.size(), this.conditionals.size()));
    }

    private static void setResponseStatusAndBody(Response response, MkAnswer answer) {
        response.setStatus(answer.status());
        byte[] body = answer.bodyBytes();
        try {
            response.createOutputStream().write(body);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write response body", ex);
        }
        response.setContentLength(body.length);
    }

    private static final class Conditional {
        private final transient MkAnswer answr;
        private final transient Matcher<MkQuery> condition;
        private final transient AtomicInteger count;

        Conditional(MkAnswer ans, Matcher<MkQuery> matcher, int times) {
            this.answr = ans;
            this.condition = matcher;
            this.count = Conditional.positiveAtomic(times);
        }

        public MkAnswer answer() {
            return this.answr;
        }

        public boolean matches(MkQuery query) {
            return this.condition.matches((Object)query);
        }

        public int decrement() {
            return this.count.decrementAndGet();
        }

        private static AtomicInteger positiveAtomic(int num) {
            if (num < 1) {
                throw new IllegalArgumentException("Answer must be returned at least once.");
            }
            return new AtomicInteger(num);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conditional)) {
                return false;
            }
            Conditional other = (Conditional)o;
            MkAnswer this$answr = this.answr;
            MkAnswer other$answr = other.answr;
            if (this$answr == null ? other$answr != null : !this$answr.equals(other$answr)) {
                return false;
            }
            Matcher<MkQuery> this$condition = this.condition;
            Matcher<MkQuery> other$condition = other.condition;
            return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MkAnswer $answr = this.answr;
            result = result * 59 + ($answr == null ? 43 : $answr.hashCode());
            Matcher<MkQuery> $condition = this.condition;
            result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
            return result;
        }
    }

    private static final class QueryWithAnswer {
        private final transient MkAnswer answr;
        private final transient MkQuery que;

        QueryWithAnswer(MkQuery qry, MkAnswer ans) {
            this.answr = ans;
            this.que = qry;
        }

        public MkQuery query() {
            return this.que;
        }

        public MkAnswer answer() {
            return this.answr;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryWithAnswer)) {
                return false;
            }
            QueryWithAnswer other = (QueryWithAnswer)o;
            MkAnswer this$answr = this.answr;
            MkAnswer other$answr = other.answr;
            if (this$answr == null ? other$answr != null : !this$answr.equals(other$answr)) {
                return false;
            }
            MkQuery this$que = this.que;
            MkQuery other$que = other.que;
            return !(this$que == null ? other$que != null : !this$que.equals(other$que));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MkAnswer $answr = this.answr;
            result = result * 59 + ($answr == null ? 43 : $answr.hashCode());
            MkQuery $que = this.que;
            result = result * 59 + ($que == null ? 43 : $que.hashCode());
            return result;
        }
    }

    private static final class MkQueryIterator
    implements Iterator<MkQuery> {
        private final Queue<MkQuery> results = new LinkedList<MkQuery>();
        private final Iterator<QueryWithAnswer> iter;
        private final Matcher<MkAnswer> matcher;

        @Override
        public boolean hasNext() {
            while (this.iter.hasNext()) {
                QueryWithAnswer candidate = this.iter.next();
                if (!this.matcher.matches((Object)candidate.answer())) continue;
                this.results.add(candidate.query());
                this.iter.remove();
                break;
            }
            return !this.results.isEmpty();
        }

        @Override
        public MkQuery next() {
            if (this.results.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.results.remove();
        }

        @Override
        public void remove() {
            this.results.remove();
        }

        @Generated
        public MkQueryIterator(Iterator<QueryWithAnswer> iter, Matcher<MkAnswer> matcher) {
            this.iter = iter;
            this.matcher = matcher;
        }
    }
}

