/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http;

import com.jcabi.aspects.Immutable;
import java.util.Map;
import lombok.Generated;

@Immutable
public final class ImmutableHeader
implements Map.Entry<String, String> {
    private final transient String left;
    private final transient String right;

    public ImmutableHeader(String key, String value) {
        this.left = ImmutableHeader.normalize(key);
        this.right = value;
    }

    @Override
    public String getKey() {
        return this.left;
    }

    @Override
    public String getValue() {
        return this.right;
    }

    @Override
    public String setValue(String value) {
        throw new UnsupportedOperationException("#setValue()");
    }

    public static String normalize(String key) {
        char[] chars = key.toCharArray();
        chars[0] = ImmutableHeader.upper(chars[0]);
        for (int pos = 1; pos < chars.length; ++pos) {
            if (chars[pos - 1] != '-') continue;
            chars[pos] = ImmutableHeader.upper(chars[pos]);
        }
        return new String(chars);
    }

    private static char upper(char chr) {
        char upper = chr >= 'a' && chr <= 'z' ? (char)(chr - 32) : chr;
        return upper;
    }

    @Generated
    public String toString() {
        return "ImmutableHeader(left=" + this.left + ", right=" + this.right + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableHeader)) {
            return false;
        }
        ImmutableHeader other = (ImmutableHeader)o;
        String this$left = this.left;
        String other$left = other.left;
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        String this$right = this.right;
        String other$right = other.right;
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $left = this.left;
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        String $right = this.right;
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }
}

