/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Commit;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
public final class MkCommit
implements Commit {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient String identifier;

    public MkCommit(MkStorage strg, String login, Coordinates crds, String commitsha) {
        this.storage = strg;
        this.self = login;
        this.coords = crds;
        this.identifier = commitsha;
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public String sha() {
        return this.identifier;
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public int compareTo(Commit commit) {
        return this.identifier.compareTo(commit.sha());
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords = '%s']/git/commits/commit[sha = '%s']", this.coords, this.identifier);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkCommit)) {
            return false;
        }
        MkCommit other = (MkCommit)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        if (this$coords == null ? other$coords != null : !this$coords.equals(other$coords)) {
            return false;
        }
        String this$identifier = this.identifier;
        String other$identifier = other.identifier;
        return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        String $identifier = this.identifier;
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        return result;
    }
}

