/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.RtJson;
import com.jcabi.github.UserEmails;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonStructure;

@Immutable
@Loggable(value=1)
final class RtUserEmails
implements UserEmails {
    private final transient Request request;

    RtUserEmails(Request req) {
        this.request = req.header("Accept", (Object)"application/vnd.github.v3").uri().path("/user/emails").back();
    }

    @Override
    public Iterable<String> iterate() throws IOException {
        List array = ((JsonResponse)((RestResponse)this.request.method("GET").fetch().as(RestResponse.class)).assertStatus(200).as(JsonResponse.class)).json().readArray().getValuesAs(JsonObject.class);
        ArrayList<String> emails = new ArrayList<String>(array.size());
        for (JsonObject obj : array) {
            emails.add(obj.getString("email"));
        }
        return emails;
    }

    @Override
    public Iterable<String> add(Iterable<String> emails) throws IOException {
        JsonArrayBuilder json = Json.createArrayBuilder();
        for (String email : emails) {
            json.add(email);
        }
        List array = ((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)json.build()).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readArray().getValuesAs(JsonObject.class);
        ArrayList<String> result = new ArrayList<String>(array.size());
        for (JsonObject obj : array) {
            result.add(obj.getString("email"));
        }
        return result;
    }

    @Override
    public void remove(Iterable<String> emails) throws IOException {
        JsonArrayBuilder json = Json.createArrayBuilder();
        for (String email : emails) {
            json.add(email);
        }
        ((RestResponse)this.request.method("DELETE").body().set((JsonStructure)json.build()).back().fetch().as(RestResponse.class)).assertStatus(204);
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtUserEmails)) {
            return false;
        }
        RtUserEmails other = (RtUserEmails)o;
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

