/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Issue;
import com.jcabi.github.IssueLabels;
import com.jcabi.github.Label;
import com.jcabi.github.RtLabel;
import com.jcabi.github.RtPagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonStructure;

@Immutable
@Loggable(value=1)
final class RtIssueLabels
implements IssueLabels {
    private final transient Request entry;
    private final transient Request request;
    private final transient Issue owner;

    RtIssueLabels(Request req, Issue issue) {
        this.owner = issue;
        Coordinates coords = issue.repo().coordinates();
        this.entry = req;
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/issues").path(Integer.toString(issue.number())).path("/labels").back();
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Issue issue() {
        return this.owner;
    }

    @Override
    public void add(Iterable<String> labels) throws IOException {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (String label : labels) {
            builder = builder.add(label);
        }
        JsonArray json = builder.build();
        ((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)json).back().fetch().as(RestResponse.class)).assertStatus(200).as(JsonResponse.class)).json().readArray();
    }

    @Override
    public void replace(Iterable<String> labels) throws IOException {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (String label : labels) {
            builder = builder.add(label);
        }
        JsonArray json = builder.build();
        ((JsonResponse)((RestResponse)this.request.method("PUT").body().set((JsonStructure)json).back().fetch().as(RestResponse.class)).assertStatus(200).as(JsonResponse.class)).json().readArray();
    }

    @Override
    public void remove(String name) throws IOException {
        ((RestResponse)this.request.method("DELETE").uri().path(name).back().fetch().as(RestResponse.class)).assertStatus(200);
    }

    @Override
    public void clear() throws IOException {
        ((RestResponse)this.request.method("DELETE").fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public Iterable<Label> iterate() {
        return new RtPagination<Label>(this.request, object -> new RtLabel(this.entry, this.owner.repo(), object.getString("name")));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtIssueLabels)) {
            return false;
        }
        RtIssueLabels other = (RtIssueLabels)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        return !(this$entry == null ? other$entry != null : !this$entry.equals(other$entry));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        return result;
    }
}

