/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.FromProperties;
import com.jcabi.github.Gists;
import com.jcabi.github.Github;
import com.jcabi.github.Gitignores;
import com.jcabi.github.Limits;
import com.jcabi.github.Markdown;
import com.jcabi.github.Organizations;
import com.jcabi.github.Repos;
import com.jcabi.github.RtGists;
import com.jcabi.github.RtGitignores;
import com.jcabi.github.RtLimits;
import com.jcabi.github.RtMarkdown;
import com.jcabi.github.RtOrganizations;
import com.jcabi.github.RtRepos;
import com.jcabi.github.RtSearch;
import com.jcabi.github.RtUsers;
import com.jcabi.github.Search;
import com.jcabi.github.Users;
import com.jcabi.http.Request;
import com.jcabi.http.request.ApacheRequest;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.wire.AutoRedirectingWire;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.json.JsonObject;
import javax.xml.bind.DatatypeConverter;

@Immutable
@Loggable(value=1)
public final class RtGithub
implements Github {
    private static final Request REQUEST = new ApacheRequest("https://api.github.com").header("User-Agent", (Object)new FromProperties("jcabigithub.properties").format()).header("Accept", (Object)"application/json").header("Content-Type", (Object)"application/json").through(AutoRedirectingWire.class, new Object[0]);
    private final transient Request request;

    public RtGithub() {
        this(REQUEST);
    }

    public RtGithub(URI domain) {
        this(REQUEST.uri().set(domain).back());
    }

    public RtGithub(String user, String pwd) {
        this(REQUEST.header("Authorization", (Object)String.format("Basic %s", DatatypeConverter.printBase64Binary((byte[])String.format("%s:%s", user, pwd).getBytes(StandardCharsets.UTF_8)))));
    }

    public RtGithub(String user, String pwd, URI domain) {
        this(REQUEST.uri().set(domain).back().header("Authorization", (Object)String.format("Basic %s", DatatypeConverter.printBase64Binary((byte[])String.format("%s:%s", user, pwd).getBytes(StandardCharsets.UTF_8)))));
    }

    public RtGithub(String token, URI domain) {
        this(REQUEST.uri().set(domain).back().header("Authorization", (Object)String.format("token %s", token)));
    }

    public RtGithub(String token) {
        this(REQUEST.header("Authorization", (Object)String.format("token %s", token)));
    }

    public RtGithub(Request req) {
        this.request = req;
    }

    @Override
    public Request entry() {
        return this.request;
    }

    @Override
    public Repos repos() {
        return new RtRepos(this, this.request);
    }

    @Override
    public Gists gists() {
        return new RtGists(this, this.request);
    }

    @Override
    public Users users() {
        return new RtUsers(this, this.request);
    }

    @Override
    public Organizations organizations() {
        return new RtOrganizations(this, this.request);
    }

    @Override
    public Limits limits() {
        return new RtLimits(this, this.request);
    }

    @Override
    public Search search() {
        return new RtSearch(this, this.request);
    }

    @Override
    public JsonObject meta() throws IOException {
        return ((JsonResponse)this.request.uri().path("meta").back().fetch().as(JsonResponse.class)).json().readObject();
    }

    @Override
    public JsonObject emojis() throws IOException {
        return ((JsonResponse)this.request.uri().path("emojis").back().fetch().as(JsonResponse.class)).json().readObject();
    }

    @Override
    public Gitignores gitignores() {
        return new RtGitignores(this);
    }

    @Override
    public Markdown markdown() {
        return new RtMarkdown(this, this.request);
    }

    public String toString() {
        return "RtGithub(request=" + this.request + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtGithub)) {
            return false;
        }
        RtGithub other = (RtGithub)o;
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

