/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Github;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.PublicMembers;
import com.jcabi.github.SmartJson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
public interface Organization
extends Comparable<Organization>,
JsonReadable,
JsonPatchable {
    public Github github();

    public String login();

    public PublicMembers publicMembers();

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Organization {
        private final transient Organization org;
        private final transient SmartJson jsn;

        public Smart(Organization orgn) {
            this.org = orgn;
            this.jsn = new SmartJson(orgn);
        }

        public int number() throws IOException {
            return this.org.json().getJsonNumber("id").intValue();
        }

        public String company() throws IOException {
            return this.jsn.text("company");
        }

        public void company(String company) throws IOException {
            this.org.patch(Json.createObjectBuilder().add("company", company).build());
        }

        public String location() throws IOException {
            return this.jsn.text("location");
        }

        public void location(String location) throws IOException {
            this.org.patch(Json.createObjectBuilder().add("location", location).build());
        }

        public String name() throws IOException {
            return this.jsn.text("name");
        }

        public void name(String name) throws IOException {
            this.org.patch(Json.createObjectBuilder().add("name", name).build());
        }

        public String email() throws IOException {
            return this.jsn.text("email");
        }

        public void email(String email) throws IOException {
            this.org.patch(Json.createObjectBuilder().add("email", email).build());
        }

        public String billingEmail() throws IOException {
            return this.jsn.text("billing_email");
        }

        public void billingEmail(String billingemail) throws IOException {
            this.org.patch(Json.createObjectBuilder().add("billing_email", billingemail).build());
        }

        public String blog() throws IOException {
            return this.jsn.text("blog");
        }

        public URL url() throws IOException {
            try {
                return new URI(this.jsn.text("url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public URL htmlUrl() throws IOException {
            try {
                return new URI(this.jsn.text("html_url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public URL avatarUrl() throws IOException {
            try {
                return new URI(this.jsn.text("avatar_url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public Date createdAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("created_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public int publicRepos() throws IOException {
            return this.jsn.number("public_repos");
        }

        public int publicGists() throws IOException {
            return this.jsn.number("public_gists");
        }

        public int followers() throws IOException {
            return this.jsn.number("followers");
        }

        public int following() throws IOException {
            return this.jsn.number("following");
        }

        public String type() throws IOException {
            return this.jsn.text("type");
        }

        @Override
        public String login() {
            return this.org.login();
        }

        @Override
        public Github github() {
            return this.org.github();
        }

        @Override
        public PublicMembers publicMembers() {
            return this.org.publicMembers();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.org.json();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.org.patch(json);
        }

        @Override
        public int compareTo(Organization obj) {
            return this.org.compareTo(obj);
        }

        public String toString() {
            return "Organization.Smart(org=" + this.org + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Organization this$org = this.org;
            Organization other$org = other.org;
            if (this$org == null ? other$org != null : !this$org.equals(other$org)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Organization $org = this.org;
            result = result * 59 + ($org == null ? 43 : $org.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

