/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.FileChange;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Repo;
import com.jcabi.github.RepoCommit;
import com.jcabi.github.RepoCommits;
import java.io.IOException;
import java.util.ArrayList;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

@Immutable
public interface CommitsComparison
extends JsonReadable {
    public Repo repo();

    public Iterable<FileChange> files() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements CommitsComparison {
        private final transient CommitsComparison comparison;

        public Smart(CommitsComparison cmprsn) {
            this.comparison = cmprsn;
        }

        public Iterable<RepoCommit> commits() throws IOException {
            JsonArray array = this.comparison.json().getJsonArray("commits");
            ArrayList<RepoCommit> commits = new ArrayList<RepoCommit>(array.size());
            RepoCommits repo = this.comparison.repo().commits();
            for (JsonValue value : array) {
                commits.add(repo.get(((JsonObject)JsonObject.class.cast(value)).getString("sha")));
            }
            return commits;
        }

        @Override
        public Iterable<FileChange> files() throws IOException {
            return this.comparison.files();
        }

        @Override
        public Repo repo() {
            return this.comparison.repo();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.comparison.json();
        }

        public String toString() {
            return "CommitsComparison.Smart(comparison=" + this.comparison + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            CommitsComparison this$comparison = this.comparison;
            CommitsComparison other$comparison = other.comparison;
            return !(this$comparison == null ? other$comparison != null : !this$comparison.equals(other$comparison));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CommitsComparison $comparison = this.comparison;
            result = result * 59 + ($comparison == null ? 43 : $comparison.hashCode());
            return result;
        }
    }
}

