/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Content;
import com.jcabi.github.Contents;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.RepoCommit;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkContent;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkRepoCommit;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonObject;
import org.apache.commons.lang3.RandomStringUtils;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkContents
implements Contents {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    public MkContents(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf((Object)"contents").up().addIf((Object)"commits"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Content readme() throws IOException {
        return this.readme("master");
    }

    @Override
    public Content readme(String branch) {
        return new MkContent(this.storage, this.self, this.coords, "README.md", branch);
    }

    @Override
    public Content create(JsonObject json) throws IOException {
        String branch;
        this.storage.lock();
        try {
            branch = json.containsKey((Object)"ref") ? json.getString("ref") : "master";
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"content").attr((Object)"ref", (Object)branch).add((Object)"name").set((Object)json.getString("path")).up().add((Object)"path").set((Object)json.getString("path")).up().add((Object)"content").set((Object)json.getString("content")).up().add((Object)"type").set((Object)"file").up().add((Object)"encoding").set((Object)"base64").up().add((Object)"sha").set((Object)MkContents.fakeSha()).up().add((Object)"url").set((Object)"http://localhost/1").up().add((Object)"git_url").set((Object)"http://localhost/2").up().add((Object)"html_url").set((Object)"http://localhost/3").up());
            this.commit(json);
        }
        finally {
            this.storage.unlock();
        }
        return new MkContent(this.storage, this.self, this.coords, json.getString("path"), branch);
    }

    @Override
    public Content get(String path, String ref) {
        return new MkContent(this.storage, this.self, this.coords, path, ref);
    }

    @Override
    public Content get(String path) {
        return new MkContent(this.storage, this.self, this.coords, path, "master");
    }

    @Override
    public Iterable<Content> iterate(String pattern, String ref) throws IOException {
        List nodes = this.storage.xml().nodes(String.format("%s/content[@ref='%s']", this.xpath(), ref));
        ArrayList<Content> result = new ArrayList<Content>(nodes.size());
        for (XML node : nodes) {
            String path = (String)node.xpath("path/text()").get(0);
            if (!path.startsWith(pattern)) continue;
            result.add(this.mkContent(ref, path));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepoCommit remove(JsonObject content) throws IOException {
        this.storage.lock();
        String path = content.getString("path");
        try {
            String branch = content.containsKey((Object)"ref") ? content.getString("ref") : "master";
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).xpath((Object)String.format("content[path='%s']", path)).attr((Object)"ref", (Object)branch).remove());
            MkRepoCommit mkRepoCommit = this.commit(content);
            return mkRepoCommit;
        }
        finally {
            this.storage.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepoCommit update(String path, JsonObject json) throws IOException {
        this.storage.lock();
        try {
            String ref = "ref";
            String branch = json.containsKey((Object)"ref") ? json.getString("ref") : "master";
            String xpath = String.format("/github/repos/repo[@coords='%s']/contents/content[path='%s' and @ref='%s']", this.coords, path, branch);
            new JsonPatch(this.storage).patch(xpath, json);
            MkRepoCommit mkRepoCommit = this.commit(json);
            return mkRepoCommit;
        }
        finally {
            this.storage.unlock();
        }
    }

    @Override
    public boolean exists(String path, String ref) throws IOException {
        return this.storage.xml().nodes(String.format("%s/content[path='%s']", this.xpath(), path)).size() > 0;
    }

    private MkContent mkContent(String ref, String path) {
        return new MkContent(this.storage, this.self, this.coords, path, ref);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/contents", this.coords);
    }

    private String commitXpath() {
        return String.format("/github/repos/repo[@coords='%s']/commits", this.coords);
    }

    private MkRepoCommit commit(JsonObject json) throws IOException {
        String sha = MkContents.fakeSha();
        Directives commit = new Directives().xpath((Object)this.commitXpath()).add((Object)"commit").add((Object)"sha").set((Object)sha).up().add((Object)"url").set((Object)"http://localhost/4").up().add((Object)"html_url").set((Object)"http://localhost/5").up().add((Object)"message").set((Object)json.getString("message")).up();
        if (json.containsKey((Object)"committer")) {
            JsonObject committer = json.getJsonObject("committer");
            commit.add((Object)"committer").add((Object)"email").set((Object)committer.getString("email")).up().add((Object)"name").set((Object)committer.getString("name")).up();
        }
        if (json.containsKey((Object)"author")) {
            JsonObject author = json.getJsonObject("author");
            commit.add((Object)"author").add((Object)"email").set((Object)author.getString("email")).up().add((Object)"name").set((Object)author.getString("name")).up();
        }
        this.storage.apply((Iterable<Directive>)commit);
        return new MkRepoCommit(this.storage, this.repo(), sha);
    }

    private static String fakeSha() {
        return RandomStringUtils.random((int)40, (String)"0123456789abcdef");
    }

    public String toString() {
        return "MkContents(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkContents)) {
            return false;
        }
        MkContents other = (MkContents)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

