/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Gist;
import com.jcabi.github.GistComment;
import com.jcabi.github.RtJson;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtGistComment
implements GistComment {
    private final transient Request request;
    private final transient Gist owner;
    private final transient int num;

    RtGistComment(Request req, Gist gist, int number) {
        this.request = req.uri().path("/gists").path(new Gist.Smart(gist).identifier()).path("/comments").path(Integer.toString(number)).back();
        this.owner = gist;
        this.num = number;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Gist gist() {
        return this.owner;
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public void remove() throws IOException {
        ((RestResponse)this.request.method("DELETE").fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public int compareTo(GistComment comment) {
        return this.number() - comment.number();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtGistComment)) {
            return false;
        }
        RtGistComment other = (RtGistComment)o;
        if (this.num != other.num) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Gist this$owner = this.owner;
        Gist other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.num;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Gist $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

