/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Bulk;
import com.jcabi.github.Issue;
import com.jcabi.github.Label;
import com.jcabi.github.Labels;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

@Immutable
public interface IssueLabels {
    public Issue issue();

    public void add(Iterable<String> var1) throws IOException;

    public void replace(Iterable<String> var1) throws IOException;

    public Iterable<Label> iterate();

    public void remove(String var1) throws IOException;

    public void clear() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements IssueLabels {
        private final transient IssueLabels labels;

        public Smart(IssueLabels lbl) {
            this.labels = lbl;
        }

        public boolean contains(String name) {
            boolean contains = false;
            for (Label label : this.labels.iterate()) {
                if (!label.name().equals(name)) continue;
                contains = true;
                break;
            }
            return contains;
        }

        public Label get(String name) {
            Label label = null;
            int count = 0;
            for (Label opt : this.labels.iterate()) {
                if (opt.name().equals(name)) {
                    label = opt;
                    break;
                }
                ++count;
            }
            if (label == null) {
                throw new IllegalArgumentException(String.format("label '%s' not found among %d others, use #contains() first", name, count));
            }
            return label;
        }

        public boolean addIfAbsent(String name) throws IOException {
            boolean added;
            if (this.contains(name)) {
                added = false;
            } else {
                new Labels.Smart(this.labels.issue().repo().labels()).createOrGet(name);
                this.labels.add(Collections.singletonList(name));
                added = true;
            }
            return added;
        }

        public boolean addIfAbsent(String name, String color) throws IOException {
            Label.Smart smart;
            Label label = null;
            for (Label opt : new Bulk<Label>(this.labels.iterate())) {
                if (!opt.name().equals(name)) continue;
                label = opt;
                break;
            }
            boolean added = false;
            if (label == null) {
                added = true;
                label = new Labels.Smart(this.labels.issue().repo().labels()).createOrGet(name, color);
                this.labels.add(Collections.singletonList(name));
            }
            if (!(smart = new Label.Smart(label)).color().equals(color)) {
                smart.color(color);
            }
            return added;
        }

        public Collection<Label> findByColor(String color) throws IOException {
            LinkedList<Label> found = new LinkedList<Label>();
            for (Label label : this.labels.iterate()) {
                if (!new Label.Smart(label).color().equals(color)) continue;
                found.add(label);
            }
            return found;
        }

        public boolean removeIfExists(String name) throws IOException {
            boolean removed = false;
            for (Label label : this.labels.iterate()) {
                if (!label.name().equals(name)) continue;
                this.remove(name);
                removed = true;
                break;
            }
            return removed;
        }

        @Override
        public Issue issue() {
            return this.labels.issue();
        }

        @Override
        public void add(Iterable<String> names) throws IOException {
            this.labels.add(names);
        }

        @Override
        public void replace(Iterable<String> names) throws IOException {
            this.labels.replace(names);
        }

        @Override
        public Iterable<Label> iterate() {
            return this.labels.iterate();
        }

        @Override
        public void remove(String name) throws IOException {
            this.labels.remove(name);
        }

        @Override
        public void clear() throws IOException {
            this.labels.clear();
        }

        public String toString() {
            return "IssueLabels.Smart(labels=" + this.labels + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            IssueLabels this$labels = this.labels;
            IssueLabels other$labels = other.labels;
            return !(this$labels == null ? other$labels != null : !this$labels.equals(other$labels));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IssueLabels $labels = this.labels;
            result = result * 59 + ($labels == null ? 43 : $labels.hashCode());
            return result;
        }
    }
}

