/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.User;
import com.jcabi.github.Users;
import com.jcabi.github.mock.MkGitHub;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import java.io.IOException;
import lombok.Generated;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkUsers
implements Users {
    private final transient MkStorage storage;
    private final transient String himself;

    MkUsers(MkStorage stg, String login) throws IOException {
        this.storage = stg;
        this.himself = login;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)"/github").addIf((Object)"users"));
        this.add(login);
    }

    @Override
    public GitHub github() {
        return new MkGitHub(this.storage, this.himself);
    }

    @Override
    public User self() {
        return this.get(this.himself);
    }

    @Override
    public User get(String login) {
        return new MkUser(this.storage, login);
    }

    @Override
    public Iterable<User> iterate(String identifier) {
        return new MkIterable<User>(this.storage, "/github/users/user", xml -> this.get((String)xml.xpath("login/text()").get(0)));
    }

    @Override
    public User add(String login) {
        try {
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/users[not(user[login='%s'])]", login)).add((Object)"user").add((Object)"login").set((Object)login).up().add((Object)"type").set((Object)"User").up().add((Object)"name").set((Object)login).up().add((Object)"notifications").up());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return this.get(login);
    }

    @Generated
    public String toString() {
        return "MkUsers(storage=" + this.storage + ", himself=" + this.himself + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkUsers)) {
            return false;
        }
        MkUsers other = (MkUsers)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$himself = this.himself;
        String other$himself = other.himself;
        return !(this$himself == null ? other$himself != null : !this$himself.equals(other$himself));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $himself = this.himself;
        result = result * 59 + ($himself == null ? 43 : $himself.hashCode());
        return result;
    }
}

