/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.Organization;
import com.jcabi.github.Organizations;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtValuePagination;
import com.jcabi.github.User;
import com.jcabi.github.UserOrganizations;
import com.jcabi.http.Request;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtUserOrganizations
implements UserOrganizations {
    private final transient Request entry;
    private final transient GitHub ghub;
    private final transient User owner;

    RtUserOrganizations(GitHub github, Request req, User user) {
        this.entry = req;
        this.ghub = github;
        this.owner = user;
    }

    @Override
    public GitHub github() {
        return this.ghub;
    }

    @Override
    public User user() {
        return this.owner;
    }

    @Override
    public Iterable<Organization> iterate() throws IOException {
        String login = this.owner.login();
        return new RtPagination<Organization>(this.entry.uri().path("/users").path(login).path("/orgs").back(), new OrganizationMapping(this.ghub.organizations()));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtUserOrganizations)) {
            return false;
        }
        RtUserOrganizations other = (RtUserOrganizations)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        GitHub this$ghub = this.ghub;
        GitHub other$ghub = other.ghub;
        if (this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub)) {
            return false;
        }
        User this$owner = this.owner;
        User other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        GitHub $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        User $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }

    private static final class OrganizationMapping
    implements RtValuePagination.Mapping<Organization, JsonObject> {
        private final transient Organizations orgs;

        OrganizationMapping(Organizations organizations) {
            this.orgs = organizations;
        }

        @Override
        public Organization map(JsonObject object) {
            return this.orgs.get(object.getString("login"));
        }
    }
}

